@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterName The name of the ECS cluster.
 * @property serviceName The name of the ECS service.
 */
public data class DeploymentGroupEcsService(
    public val clusterName: String,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupEcsService): DeploymentGroupEcsService = DeploymentGroupEcsService(
            clusterName = javaType.clusterName(),
            serviceName = javaType.serviceName(),
        )
    }
}
