@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property prodTrafficRoute Configuration block for the production traffic route (documented below).
 * @property targetGroups Configuration blocks for a target group within a target group pair (documented below).
 * @property testTrafficRoute Configuration block for the test traffic route (documented below).
 */
public data class DeploymentGroupLoadBalancerInfoTargetGroupPairInfo(
    public val prodTrafficRoute: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRoute,
    public val targetGroups: List<DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroup>,
    public val testTrafficRoute: DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRoute? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfo): DeploymentGroupLoadBalancerInfoTargetGroupPairInfo =
            DeploymentGroupLoadBalancerInfoTargetGroupPairInfo(
                prodTrafficRoute = javaType.prodTrafficRoute().let({ args0 ->
                    com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoProdTrafficRoute.Companion.toKotlin(args0)
                }),
                targetGroups = javaType.targetGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTargetGroup.Companion.toKotlin(args0)
                    })
                }),
                testTrafficRoute = javaType.testTrafficRoute().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.codedeploy.kotlin.outputs.DeploymentGroupLoadBalancerInfoTargetGroupPairInfoTestTrafficRoute.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
