@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codedeploy.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property triggerEvents The event type or types for which notifications are triggered. Some values that are supported: `DeploymentStart`, `DeploymentSuccess`, `DeploymentFailure`, `DeploymentStop`, `DeploymentRollback`, `InstanceStart`, `InstanceSuccess`, `InstanceFailure`.  See [the CodeDeploy documentation](http://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html) for all possible values.
 * @property triggerName The name of the notification trigger.
 * @property triggerTargetArn The ARN of the SNS topic through which notifications are sent.
 */
public data class DeploymentGroupTriggerConfiguration(
    public val triggerEvents: List<String>,
    public val triggerName: String,
    public val triggerTargetArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codedeploy.outputs.DeploymentGroupTriggerConfiguration): DeploymentGroupTriggerConfiguration = DeploymentGroupTriggerConfiguration(
            triggerEvents = javaType.triggerEvents().map({ args0 -> args0 }),
            triggerName = javaType.triggerName(),
            triggerTargetArn = javaType.triggerTargetArn(),
        )
    }
}
