@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin

import com.pulumi.aws.codeguruprofiler.CodeguruprofilerFunctions.getProfilingGroupPlain
import com.pulumi.aws.codeguruprofiler.kotlin.inputs.GetProfilingGroupPlainArgs
import com.pulumi.aws.codeguruprofiler.kotlin.inputs.GetProfilingGroupPlainArgsBuilder
import com.pulumi.aws.codeguruprofiler.kotlin.outputs.GetProfilingGroupResult
import com.pulumi.aws.codeguruprofiler.kotlin.outputs.GetProfilingGroupResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object CodeguruprofilerFunctions {
    /**
     * Data source for managing an AWS CodeGuru Profiler Profiling Group.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.codeguruprofiler.getProfilingGroup({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.codeguruprofiler.get_profiling_group(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CodeGuruProfiler.GetProfilingGroup.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeguruprofiler"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codeguruprofiler.LookupProfilingGroup(ctx, &codeguruprofiler.LookupProfilingGroupArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codeguruprofiler.CodeguruprofilerFunctions;
     * import com.pulumi.aws.codeguruprofiler.inputs.GetProfilingGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodeguruprofilerFunctions.getProfilingGroup(GetProfilingGroupArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:codeguruprofiler:getProfilingGroup
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProfilingGroup.
     * @return A collection of values returned by getProfilingGroup.
     */
    public suspend fun getProfilingGroup(argument: GetProfilingGroupPlainArgs): GetProfilingGroupResult = toKotlin(getProfilingGroupPlain(argument.toJava()).await())

    /**
     * @see [getProfilingGroup].
     * @param name The name of the profiling group.
     * @return A collection of values returned by getProfilingGroup.
     */
    public suspend fun getProfilingGroup(name: String): GetProfilingGroupResult {
        val argument = GetProfilingGroupPlainArgs(
            name = name,
        )
        return toKotlin(getProfilingGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getProfilingGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codeguruprofiler&#46;kotlin&#46;inputs&#46;GetProfilingGroupPlainArgs].
     * @return A collection of values returned by getProfilingGroup.
     */
    public suspend fun getProfilingGroup(argument: suspend GetProfilingGroupPlainArgsBuilder.() -> Unit): GetProfilingGroupResult {
        val builder = GetProfilingGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getProfilingGroupPlain(builtArgument.toJava()).await())
    }
}
