@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin

import com.pulumi.aws.codeguruprofiler.kotlin.outputs.ProfilingGroupAgentOrchestrationConfig
import com.pulumi.aws.codeguruprofiler.kotlin.outputs.ProfilingGroupAgentOrchestrationConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProfilingGroup].
 */
@PulumiTagMarker
public class ProfilingGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfilingGroupArgs = ProfilingGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfilingGroupArgsBuilder.() -> Unit) {
        val builder = ProfilingGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProfilingGroup {
        val builtJavaResource = com.pulumi.aws.codeguruprofiler.ProfilingGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProfilingGroup(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CodeGuru Profiler Profiling Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codeguruprofiler.ProfilingGroup("example", {
 *     name: "example",
 *     computePlatform: "Default",
 *     agentOrchestrationConfig: {
 *         profilingEnabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codeguruprofiler.ProfilingGroup("example",
 *     name="example",
 *     compute_platform="Default",
 *     agent_orchestration_config={
 *         "profiling_enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeGuruProfiler.ProfilingGroup("example", new()
 *     {
 *         Name = "example",
 *         ComputePlatform = "Default",
 *         AgentOrchestrationConfig = new Aws.CodeGuruProfiler.Inputs.ProfilingGroupAgentOrchestrationConfigArgs
 *         {
 *             ProfilingEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeguruprofiler"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codeguruprofiler.NewProfilingGroup(ctx, "example", &codeguruprofiler.ProfilingGroupArgs{
 * 			Name:            pulumi.String("example"),
 * 			ComputePlatform: pulumi.String("Default"),
 * 			AgentOrchestrationConfig: &codeguruprofiler.ProfilingGroupAgentOrchestrationConfigArgs{
 * 				ProfilingEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeguruprofiler.ProfilingGroup;
 * import com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs;
 * import com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProfilingGroup("example", ProfilingGroupArgs.builder()
 *             .name("example")
 *             .computePlatform("Default")
 *             .agentOrchestrationConfig(ProfilingGroupAgentOrchestrationConfigArgs.builder()
 *                 .profilingEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codeguruprofiler:ProfilingGroup
 *     properties:
 *       name: example
 *       computePlatform: Default
 *       agentOrchestrationConfig:
 *         profilingEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeGuru Profiler Profiling Group using the `id`. For example:
 * ```sh
 * $ pulumi import aws:codeguruprofiler/profilingGroup:ProfilingGroup example profiling_group-name-12345678
 * ```
 */
public class ProfilingGroup internal constructor(
    override val javaResource: com.pulumi.aws.codeguruprofiler.ProfilingGroup,
) : KotlinCustomResource(javaResource, ProfilingGroupMapper) {
    /**
     * Specifies whether profiling is enabled or disabled for the created profiling. See Agent Orchestration Config for more details.
     */
    public val agentOrchestrationConfig: Output<ProfilingGroupAgentOrchestrationConfig>?
        get() = javaResource.agentOrchestrationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN of the profiling group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Compute platform of the profiling group.
     */
    public val computePlatform: Output<String>
        get() = javaResource.computePlatform().applyValue({ args0 -> args0 })

    /**
     * Name of the profiling group.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProfilingGroupMapper : ResourceMapper<ProfilingGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeguruprofiler.ProfilingGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProfilingGroup = ProfilingGroup(
        javaResource as
            com.pulumi.aws.codeguruprofiler.ProfilingGroup,
    )
}

/**
 * @see [ProfilingGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProfilingGroup].
 */
public suspend fun profilingGroup(
    name: String,
    block: suspend ProfilingGroupResourceBuilder.() -> Unit,
): ProfilingGroup {
    val builder = ProfilingGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProfilingGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profilingGroup(name: String): ProfilingGroup {
    val builder = ProfilingGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
