@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin

import com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs.builder
import com.pulumi.aws.codeguruprofiler.kotlin.inputs.ProfilingGroupAgentOrchestrationConfigArgs
import com.pulumi.aws.codeguruprofiler.kotlin.inputs.ProfilingGroupAgentOrchestrationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeGuru Profiler Profiling Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codeguruprofiler.ProfilingGroup("example", {
 *     name: "example",
 *     computePlatform: "Default",
 *     agentOrchestrationConfig: {
 *         profilingEnabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codeguruprofiler.ProfilingGroup("example",
 *     name="example",
 *     compute_platform="Default",
 *     agent_orchestration_config={
 *         "profiling_enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeGuruProfiler.ProfilingGroup("example", new()
 *     {
 *         Name = "example",
 *         ComputePlatform = "Default",
 *         AgentOrchestrationConfig = new Aws.CodeGuruProfiler.Inputs.ProfilingGroupAgentOrchestrationConfigArgs
 *         {
 *             ProfilingEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeguruprofiler"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codeguruprofiler.NewProfilingGroup(ctx, "example", &codeguruprofiler.ProfilingGroupArgs{
 * 			Name:            pulumi.String("example"),
 * 			ComputePlatform: pulumi.String("Default"),
 * 			AgentOrchestrationConfig: &codeguruprofiler.ProfilingGroupAgentOrchestrationConfigArgs{
 * 				ProfilingEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeguruprofiler.ProfilingGroup;
 * import com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs;
 * import com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProfilingGroup("example", ProfilingGroupArgs.builder()
 *             .name("example")
 *             .computePlatform("Default")
 *             .agentOrchestrationConfig(ProfilingGroupAgentOrchestrationConfigArgs.builder()
 *                 .profilingEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codeguruprofiler:ProfilingGroup
 *     properties:
 *       name: example
 *       computePlatform: Default
 *       agentOrchestrationConfig:
 *         profilingEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeGuru Profiler Profiling Group using the `id`. For example:
 * ```sh
 * $ pulumi import aws:codeguruprofiler/profilingGroup:ProfilingGroup example profiling_group-name-12345678
 * ```
 * @property agentOrchestrationConfig Specifies whether profiling is enabled or disabled for the created profiling. See Agent Orchestration Config for more details.
 * @property computePlatform Compute platform of the profiling group.
 * @property name Name of the profiling group.
 * The following arguments are optional:
 * @property tags Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProfilingGroupArgs(
    public val agentOrchestrationConfig: Output<ProfilingGroupAgentOrchestrationConfigArgs>? = null,
    public val computePlatform: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs> {
    override fun toJava(): com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs =
        com.pulumi.aws.codeguruprofiler.ProfilingGroupArgs.builder()
            .agentOrchestrationConfig(
                agentOrchestrationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .computePlatform(computePlatform?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfilingGroupArgs].
 */
@PulumiTagMarker
public class ProfilingGroupArgsBuilder internal constructor() {
    private var agentOrchestrationConfig: Output<ProfilingGroupAgentOrchestrationConfigArgs>? = null

    private var computePlatform: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether profiling is enabled or disabled for the created profiling. See Agent Orchestration Config for more details.
     */
    @JvmName("peidlrywhgnabhqi")
    public suspend fun agentOrchestrationConfig(`value`: Output<ProfilingGroupAgentOrchestrationConfigArgs>) {
        this.agentOrchestrationConfig = value
    }

    /**
     * @param value Compute platform of the profiling group.
     */
    @JvmName("yebfyihkfggpqatr")
    public suspend fun computePlatform(`value`: Output<String>) {
        this.computePlatform = value
    }

    /**
     * @param value Name of the profiling group.
     * The following arguments are optional:
     */
    @JvmName("lixlbhouypvqijuq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sdfujgnjcjacadvy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether profiling is enabled or disabled for the created profiling. See Agent Orchestration Config for more details.
     */
    @JvmName("srqmvmewavwsirdg")
    public suspend fun agentOrchestrationConfig(`value`: ProfilingGroupAgentOrchestrationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentOrchestrationConfig = mapped
    }

    /**
     * @param argument Specifies whether profiling is enabled or disabled for the created profiling. See Agent Orchestration Config for more details.
     */
    @JvmName("ereyoinvvdcxocwy")
    public suspend fun agentOrchestrationConfig(argument: suspend ProfilingGroupAgentOrchestrationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProfilingGroupAgentOrchestrationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.agentOrchestrationConfig = mapped
    }

    /**
     * @param value Compute platform of the profiling group.
     */
    @JvmName("mrvmugwfbblgntii")
    public suspend fun computePlatform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computePlatform = mapped
    }

    /**
     * @param value Name of the profiling group.
     * The following arguments are optional:
     */
    @JvmName("lnihljsigkiyeiwm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("krsvluuddqhboxqp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kleaduwkxyxswxtf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfilingGroupArgs = ProfilingGroupArgs(
        agentOrchestrationConfig = agentOrchestrationConfig,
        computePlatform = computePlatform,
        name = name,
        tags = tags,
    )
}
