@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin.inputs

import com.pulumi.aws.codeguruprofiler.inputs.GetProfilingGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProfilingGroup.
 * @property name The name of the profiling group.
 */
public data class GetProfilingGroupPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.codeguruprofiler.inputs.GetProfilingGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.codeguruprofiler.inputs.GetProfilingGroupPlainArgs =
        com.pulumi.aws.codeguruprofiler.inputs.GetProfilingGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProfilingGroupPlainArgs].
 */
@PulumiTagMarker
public class GetProfilingGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value The name of the profiling group.
     */
    @JvmName("lwoyndordselmvwc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetProfilingGroupPlainArgs = GetProfilingGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
