@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin.inputs

import com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property profilingEnabled (Required) Boolean that specifies whether the profiling agent collects profiling data or
 */
public data class ProfilingGroupAgentOrchestrationConfigArgs(
    public val profilingEnabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs> {
    override fun toJava(): com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs =
        com.pulumi.aws.codeguruprofiler.inputs.ProfilingGroupAgentOrchestrationConfigArgs.builder()
            .profilingEnabled(profilingEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfilingGroupAgentOrchestrationConfigArgs].
 */
@PulumiTagMarker
public class ProfilingGroupAgentOrchestrationConfigArgsBuilder internal constructor() {
    private var profilingEnabled: Output<Boolean>? = null

    /**
     * @param value (Required) Boolean that specifies whether the profiling agent collects profiling data or
     */
    @JvmName("wjkyjfjxrjjjenda")
    public suspend fun profilingEnabled(`value`: Output<Boolean>) {
        this.profilingEnabled = value
    }

    /**
     * @param value (Required) Boolean that specifies whether the profiling agent collects profiling data or
     */
    @JvmName("ylbqtroackcfamfc")
    public suspend fun profilingEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profilingEnabled = mapped
    }

    internal fun build(): ProfilingGroupAgentOrchestrationConfigArgs =
        ProfilingGroupAgentOrchestrationConfigArgs(
            profilingEnabled = profilingEnabled ?: throw PulumiNullFieldException("profilingEnabled"),
        )
}
