@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeguruprofiler.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getProfilingGroup.
 * @property agentOrchestrationConfigs Profiling Group agent orchestration config
 * @property arn ARN of the Profiling Group.
 * @property computePlatform The compute platform of the profiling group.
 * @property createdAt Timestamp when Profiling Group was created.
 * @property id
 * @property name
 * @property profilingStatuses The status of the Profiling Group.
 * @property tags Mapping of Key-Value tags for the resource.
 * @property updatedAt Timestamp when Profiling Group was updated.
 */
public data class GetProfilingGroupResult(
    public val agentOrchestrationConfigs: List<GetProfilingGroupAgentOrchestrationConfig>,
    public val arn: String,
    public val computePlatform: String,
    public val createdAt: String,
    public val id: String,
    public val name: String,
    public val profilingStatuses: List<GetProfilingGroupProfilingStatus>,
    public val tags: Map<String, String>,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codeguruprofiler.outputs.GetProfilingGroupResult): GetProfilingGroupResult = GetProfilingGroupResult(
            agentOrchestrationConfigs = javaType.agentOrchestrationConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codeguruprofiler.kotlin.outputs.GetProfilingGroupAgentOrchestrationConfig.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            computePlatform = javaType.computePlatform(),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            name = javaType.name(),
            profilingStatuses = javaType.profilingStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codeguruprofiler.kotlin.outputs.GetProfilingGroupProfilingStatus.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
