@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin

import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationKmsKeyDetails
import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepository
import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationS3RepositoryDetail
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationKmsKeyDetails.Companion.toKotlin as repositoryAssociationKmsKeyDetailsToKotlin
import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepository.Companion.toKotlin as repositoryAssociationRepositoryToKotlin
import com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationS3RepositoryDetail.Companion.toKotlin as repositoryAssociationS3RepositoryDetailToKotlin

/**
 * Builder for [RepositoryAssociation].
 */
@PulumiTagMarker
public class RepositoryAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryAssociationArgs = RepositoryAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryAssociationArgsBuilder.() -> Unit) {
        val builder = RepositoryAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RepositoryAssociation {
        val builtJavaResource =
            com.pulumi.aws.codegurureviewer.RepositoryAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RepositoryAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS CodeGuru Reviewer Repository Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {});
 * const exampleRepository = new aws.codecommit.Repository("example", {repositoryName: "example-repo"});
 * const exampleRepositoryAssociation = new aws.codegurureviewer.RepositoryAssociation("example", {
 *     repository: {
 *         codecommit: {
 *             name: exampleRepository.repositoryName,
 *         },
 *     },
 *     kmsKeyDetails: {
 *         encryptionOption: "CUSTOMER_MANAGED_CMK",
 *         kmsKeyId: example.keyId,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example")
 * example_repository = aws.codecommit.Repository("example", repository_name="example-repo")
 * example_repository_association = aws.codegurureviewer.RepositoryAssociation("example",
 *     repository={
 *         "codecommit": {
 *             "name": example_repository.repository_name,
 *         },
 *     },
 *     kms_key_details={
 *         "encryption_option": "CUSTOMER_MANAGED_CMK",
 *         "kms_key_id": example.key_id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example");
 *     var exampleRepository = new Aws.CodeCommit.Repository("example", new()
 *     {
 *         RepositoryName = "example-repo",
 *     });
 *     var exampleRepositoryAssociation = new Aws.CodeGuruReviewer.RepositoryAssociation("example", new()
 *     {
 *         Repository = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationRepositoryArgs
 *         {
 *             Codecommit = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationRepositoryCodecommitArgs
 *             {
 *                 Name = exampleRepository.RepositoryName,
 *             },
 *         },
 *         KmsKeyDetails = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationKmsKeyDetailsArgs
 *         {
 *             EncryptionOption = "CUSTOMER_MANAGED_CMK",
 *             KmsKeyId = example.KeyId,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codegurureviewer"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRepository, err := codecommit.NewRepository(ctx, "example", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("example-repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codegurureviewer.NewRepositoryAssociation(ctx, "example", &codegurureviewer.RepositoryAssociationArgs{
 * 			Repository: &codegurureviewer.RepositoryAssociationRepositoryArgs{
 * 				Codecommit: &codegurureviewer.RepositoryAssociationRepositoryCodecommitArgs{
 * 					Name: exampleRepository.RepositoryName,
 * 				},
 * 			},
 * 			KmsKeyDetails: &codegurureviewer.RepositoryAssociationKmsKeyDetailsArgs{
 * 				EncryptionOption: pulumi.String("CUSTOMER_MANAGED_CMK"),
 * 				KmsKeyId:         example.KeyId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociation;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example");
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example-repo")
 *             .build());
 *         var exampleRepositoryAssociation = new RepositoryAssociation("exampleRepositoryAssociation", RepositoryAssociationArgs.builder()
 *             .repository(RepositoryAssociationRepositoryArgs.builder()
 *                 .codecommit(RepositoryAssociationRepositoryCodecommitArgs.builder()
 *                     .name(exampleRepository.repositoryName())
 *                     .build())
 *                 .build())
 *             .kmsKeyDetails(RepositoryAssociationKmsKeyDetailsArgs.builder()
 *                 .encryptionOption("CUSTOMER_MANAGED_CMK")
 *                 .kmsKeyId(example.keyId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *   exampleRepository:
 *     type: aws:codecommit:Repository
 *     name: example
 *     properties:
 *       repositoryName: example-repo
 *   exampleRepositoryAssociation:
 *     type: aws:codegurureviewer:RepositoryAssociation
 *     name: example
 *     properties:
 *       repository:
 *         codecommit:
 *           name: ${exampleRepository.repositoryName}
 *       kmsKeyDetails:
 *         encryptionOption: CUSTOMER_MANAGED_CMK
 *         kmsKeyId: ${example.keyId}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class RepositoryAssociation internal constructor(
    override val javaResource: com.pulumi.aws.codegurureviewer.RepositoryAssociation,
) : KotlinCustomResource(javaResource, RepositoryAssociationMapper) {
    /**
     * The Amazon Resource Name (ARN) identifying the repository association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the repository association.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection.
     */
    public val connectionArn: Output<String>
        get() = javaResource.connectionArn().applyValue({ args0 -> args0 })

    /**
     * An object describing the KMS key to asssociate. Block is documented below.
     */
    public val kmsKeyDetails: Output<RepositoryAssociationKmsKeyDetails>?
        get() = javaResource.kmsKeyDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> repositoryAssociationKmsKeyDetailsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the repository.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The owner of the repository.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The provider type of the repository association.
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })

    /**
     * An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    public val repository: Output<RepositoryAssociationRepository>
        get() = javaResource.repository().applyValue({ args0 ->
            args0.let({ args0 ->
                repositoryAssociationRepositoryToKotlin(args0)
            })
        })

    public val s3RepositoryDetails: Output<List<RepositoryAssociationS3RepositoryDetail>>
        get() = javaResource.s3RepositoryDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> repositoryAssociationS3RepositoryDetailToKotlin(args0) })
            })
        })

    /**
     * The state of the repository association.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * A description of why the repository association is in the current state.
     */
    public val stateReason: Output<String>
        get() = javaResource.stateReason().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RepositoryAssociationMapper : ResourceMapper<RepositoryAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codegurureviewer.RepositoryAssociation::class == javaResource::class

    override fun map(javaResource: Resource): RepositoryAssociation =
        RepositoryAssociation(javaResource as com.pulumi.aws.codegurureviewer.RepositoryAssociation)
}

/**
 * @see [RepositoryAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RepositoryAssociation].
 */
public suspend fun repositoryAssociation(
    name: String,
    block: suspend RepositoryAssociationResourceBuilder.() -> Unit,
): RepositoryAssociation {
    val builder = RepositoryAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RepositoryAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repositoryAssociation(name: String): RepositoryAssociation {
    val builder = RepositoryAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
