@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin

import com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs.builder
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationKmsKeyDetailsArgs
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationKmsKeyDetailsArgsBuilder
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationRepositoryArgs
import com.pulumi.aws.codegurureviewer.kotlin.inputs.RepositoryAssociationRepositoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS CodeGuru Reviewer Repository Association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {});
 * const exampleRepository = new aws.codecommit.Repository("example", {repositoryName: "example-repo"});
 * const exampleRepositoryAssociation = new aws.codegurureviewer.RepositoryAssociation("example", {
 *     repository: {
 *         codecommit: {
 *             name: exampleRepository.repositoryName,
 *         },
 *     },
 *     kmsKeyDetails: {
 *         encryptionOption: "CUSTOMER_MANAGED_CMK",
 *         kmsKeyId: example.keyId,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example")
 * example_repository = aws.codecommit.Repository("example", repository_name="example-repo")
 * example_repository_association = aws.codegurureviewer.RepositoryAssociation("example",
 *     repository={
 *         "codecommit": {
 *             "name": example_repository.repository_name,
 *         },
 *     },
 *     kms_key_details={
 *         "encryption_option": "CUSTOMER_MANAGED_CMK",
 *         "kms_key_id": example.key_id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example");
 *     var exampleRepository = new Aws.CodeCommit.Repository("example", new()
 *     {
 *         RepositoryName = "example-repo",
 *     });
 *     var exampleRepositoryAssociation = new Aws.CodeGuruReviewer.RepositoryAssociation("example", new()
 *     {
 *         Repository = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationRepositoryArgs
 *         {
 *             Codecommit = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationRepositoryCodecommitArgs
 *             {
 *                 Name = exampleRepository.RepositoryName,
 *             },
 *         },
 *         KmsKeyDetails = new Aws.CodeGuruReviewer.Inputs.RepositoryAssociationKmsKeyDetailsArgs
 *         {
 *             EncryptionOption = "CUSTOMER_MANAGED_CMK",
 *             KmsKeyId = example.KeyId,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codegurureviewer"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRepository, err := codecommit.NewRepository(ctx, "example", &codecommit.RepositoryArgs{
 * 			RepositoryName: pulumi.String("example-repo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codegurureviewer.NewRepositoryAssociation(ctx, "example", &codegurureviewer.RepositoryAssociationArgs{
 * 			Repository: &codegurureviewer.RepositoryAssociationRepositoryArgs{
 * 				Codecommit: &codegurureviewer.RepositoryAssociationRepositoryCodecommitArgs{
 * 					Name: exampleRepository.RepositoryName,
 * 				},
 * 			},
 * 			KmsKeyDetails: &codegurureviewer.RepositoryAssociationKmsKeyDetailsArgs{
 * 				EncryptionOption: pulumi.String("CUSTOMER_MANAGED_CMK"),
 * 				KmsKeyId:         example.KeyId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociation;
 * import com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs;
 * import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example");
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repositoryName("example-repo")
 *             .build());
 *         var exampleRepositoryAssociation = new RepositoryAssociation("exampleRepositoryAssociation", RepositoryAssociationArgs.builder()
 *             .repository(RepositoryAssociationRepositoryArgs.builder()
 *                 .codecommit(RepositoryAssociationRepositoryCodecommitArgs.builder()
 *                     .name(exampleRepository.repositoryName())
 *                     .build())
 *                 .build())
 *             .kmsKeyDetails(RepositoryAssociationKmsKeyDetailsArgs.builder()
 *                 .encryptionOption("CUSTOMER_MANAGED_CMK")
 *                 .kmsKeyId(example.keyId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *   exampleRepository:
 *     type: aws:codecommit:Repository
 *     name: example
 *     properties:
 *       repositoryName: example-repo
 *   exampleRepositoryAssociation:
 *     type: aws:codegurureviewer:RepositoryAssociation
 *     name: example
 *     properties:
 *       repository:
 *         codecommit:
 *           name: ${exampleRepository.repositoryName}
 *       kmsKeyDetails:
 *         encryptionOption: CUSTOMER_MANAGED_CMK
 *         kmsKeyId: ${example.keyId}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property kmsKeyDetails An object describing the KMS key to asssociate. Block is documented below.
 * @property repository An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
 * The following arguments are optional:
 * @property tags
 */
public data class RepositoryAssociationArgs(
    public val kmsKeyDetails: Output<RepositoryAssociationKmsKeyDetailsArgs>? = null,
    public val repository: Output<RepositoryAssociationRepositoryArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs> {
    override fun toJava(): com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs =
        com.pulumi.aws.codegurureviewer.RepositoryAssociationArgs.builder()
            .kmsKeyDetails(kmsKeyDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .repository(repository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RepositoryAssociationArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationArgsBuilder internal constructor() {
    private var kmsKeyDetails: Output<RepositoryAssociationKmsKeyDetailsArgs>? = null

    private var repository: Output<RepositoryAssociationRepositoryArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("nahxrogudlmepuxa")
    public suspend fun kmsKeyDetails(`value`: Output<RepositoryAssociationKmsKeyDetailsArgs>) {
        this.kmsKeyDetails = value
    }

    /**
     * @param value An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("vqqmorttgawyiduv")
    public suspend fun repository(`value`: Output<RepositoryAssociationRepositoryArgs>) {
        this.repository = value
    }

    /**
     * @param value
     */
    @JvmName("dephyqsaesfeiksd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("comsiqecluhxiwdx")
    public suspend fun kmsKeyDetails(`value`: RepositoryAssociationKmsKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyDetails = mapped
    }

    /**
     * @param argument An object describing the KMS key to asssociate. Block is documented below.
     */
    @JvmName("togfcpuaxncwcpka")
    public suspend fun kmsKeyDetails(argument: suspend RepositoryAssociationKmsKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationKmsKeyDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kmsKeyDetails = mapped
    }

    /**
     * @param value An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("ffcubghuyjiiyqtw")
    public suspend fun repository(`value`: RepositoryAssociationRepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param argument An object describing the repository to associate. Valid values: `bitbucket`, `codecommit`, `github_enterprise_server`, or `s3_bucket`. Block is documented below. Note: for repositories that leverage CodeStar connections (ex. `bitbucket`, `github_enterprise_server`) the connection must be in `Available` status prior to creating this resource.
     * The following arguments are optional:
     */
    @JvmName("aqnaeiabcvqmoagk")
    public suspend fun repository(argument: suspend RepositoryAssociationRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationRepositoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.repository = mapped
    }

    /**
     * @param value
     */
    @JvmName("bupqasmehuwpvypp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fenbkjnjotbrdjhn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RepositoryAssociationArgs = RepositoryAssociationArgs(
        kmsKeyDetails = kmsKeyDetails,
        repository = repository,
        tags = tags,
    )
}
