@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.inputs

import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionOption The encryption option for a repository association. It is either owned by AWS Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
 * @property kmsKeyId The ID of the AWS KMS key that is associated with a repository association.
 */
public data class RepositoryAssociationKmsKeyDetailsArgs(
    public val encryptionOption: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs> {
    override fun toJava(): com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs =
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationKmsKeyDetailsArgs.builder()
            .encryptionOption(encryptionOption?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryAssociationKmsKeyDetailsArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationKmsKeyDetailsArgsBuilder internal constructor() {
    private var encryptionOption: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The encryption option for a repository association. It is either owned by AWS Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
     */
    @JvmName("lxhanxwarfdroyep")
    public suspend fun encryptionOption(`value`: Output<String>) {
        this.encryptionOption = value
    }

    /**
     * @param value The ID of the AWS KMS key that is associated with a repository association.
     */
    @JvmName("obfraihhxamuwvtg")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The encryption option for a repository association. It is either owned by AWS Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
     */
    @JvmName("orhuglctrkbwoovp")
    public suspend fun encryptionOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionOption = mapped
    }

    /**
     * @param value The ID of the AWS KMS key that is associated with a repository association.
     */
    @JvmName("fboincpegscknbky")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): RepositoryAssociationKmsKeyDetailsArgs =
        RepositoryAssociationKmsKeyDetailsArgs(
            encryptionOption = encryptionOption,
            kmsKeyId = kmsKeyId,
        )
}
