@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.inputs

import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bitbucket
 * @property codecommit
 * @property githubEnterpriseServer
 * @property s3Bucket
 */
public data class RepositoryAssociationRepositoryArgs(
    public val bitbucket: Output<RepositoryAssociationRepositoryBitbucketArgs>? = null,
    public val codecommit: Output<RepositoryAssociationRepositoryCodecommitArgs>? = null,
    public val githubEnterpriseServer: Output<RepositoryAssociationRepositoryGithubEnterpriseServerArgs>? = null,
    public val s3Bucket: Output<RepositoryAssociationRepositoryS3BucketArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs = com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryArgs.builder()
        .bitbucket(bitbucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .codecommit(codecommit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .githubEnterpriseServer(
            githubEnterpriseServer?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .s3Bucket(s3Bucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RepositoryAssociationRepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationRepositoryArgsBuilder internal constructor() {
    private var bitbucket: Output<RepositoryAssociationRepositoryBitbucketArgs>? = null

    private var codecommit: Output<RepositoryAssociationRepositoryCodecommitArgs>? = null

    private var githubEnterpriseServer:
        Output<RepositoryAssociationRepositoryGithubEnterpriseServerArgs>? = null

    private var s3Bucket: Output<RepositoryAssociationRepositoryS3BucketArgs>? = null

    /**
     * @param value
     */
    @JvmName("iaaoubdpvxgwwoug")
    public suspend fun bitbucket(`value`: Output<RepositoryAssociationRepositoryBitbucketArgs>) {
        this.bitbucket = value
    }

    /**
     * @param value
     */
    @JvmName("mrvsjhwvdhhgvxwr")
    public suspend fun codecommit(`value`: Output<RepositoryAssociationRepositoryCodecommitArgs>) {
        this.codecommit = value
    }

    /**
     * @param value
     */
    @JvmName("ocktdiovuyvfweux")
    public suspend fun githubEnterpriseServer(`value`: Output<RepositoryAssociationRepositoryGithubEnterpriseServerArgs>) {
        this.githubEnterpriseServer = value
    }

    /**
     * @param value
     */
    @JvmName("ehdtyugjpxpjluml")
    public suspend fun s3Bucket(`value`: Output<RepositoryAssociationRepositoryS3BucketArgs>) {
        this.s3Bucket = value
    }

    /**
     * @param value
     */
    @JvmName("knttllpviocbhxhi")
    public suspend fun bitbucket(`value`: RepositoryAssociationRepositoryBitbucketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitbucket = mapped
    }

    /**
     * @param argument
     */
    @JvmName("liocsfynkdvtjycv")
    public suspend fun bitbucket(argument: suspend RepositoryAssociationRepositoryBitbucketArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationRepositoryBitbucketArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.bitbucket = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmxogwfvxknkjfjb")
    public suspend fun codecommit(`value`: RepositoryAssociationRepositoryCodecommitArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecommit = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eruyvqgwiuwpxyaa")
    public suspend fun codecommit(argument: suspend RepositoryAssociationRepositoryCodecommitArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationRepositoryCodecommitArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codecommit = mapped
    }

    /**
     * @param value
     */
    @JvmName("uppdvtqsamokyenf")
    public suspend fun githubEnterpriseServer(`value`: RepositoryAssociationRepositoryGithubEnterpriseServerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.githubEnterpriseServer = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rioxxvvdlsfcwlbt")
    public suspend fun githubEnterpriseServer(argument: suspend RepositoryAssociationRepositoryGithubEnterpriseServerArgsBuilder.() -> Unit) {
        val toBeMapped =
            RepositoryAssociationRepositoryGithubEnterpriseServerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.githubEnterpriseServer = mapped
    }

    /**
     * @param value
     */
    @JvmName("tponwoqxdybvcxjv")
    public suspend fun s3Bucket(`value`: RepositoryAssociationRepositoryS3BucketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ujvwhrolabgcmtpx")
    public suspend fun s3Bucket(argument: suspend RepositoryAssociationRepositoryS3BucketArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryAssociationRepositoryS3BucketArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Bucket = mapped
    }

    internal fun build(): RepositoryAssociationRepositoryArgs = RepositoryAssociationRepositoryArgs(
        bitbucket = bitbucket,
        codecommit = codecommit,
        githubEnterpriseServer = githubEnterpriseServer,
        s3Bucket = s3Bucket,
    )
}
