@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.inputs

import com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the AWS CodeCommit repository.
 */
public data class RepositoryAssociationRepositoryCodecommitArgs(
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs> {
    override fun toJava(): com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs =
        com.pulumi.aws.codegurureviewer.inputs.RepositoryAssociationRepositoryCodecommitArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryAssociationRepositoryCodecommitArgs].
 */
@PulumiTagMarker
public class RepositoryAssociationRepositoryCodecommitArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the AWS CodeCommit repository.
     */
    @JvmName("kpvthjcankycqrcd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the AWS CodeCommit repository.
     */
    @JvmName("ytabatemmkcdrgeb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RepositoryAssociationRepositoryCodecommitArgs =
        RepositoryAssociationRepositoryCodecommitArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
