@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codegurureviewer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property bitbucket
 * @property codecommit
 * @property githubEnterpriseServer
 * @property s3Bucket
 */
public data class RepositoryAssociationRepository(
    public val bitbucket: RepositoryAssociationRepositoryBitbucket? = null,
    public val codecommit: RepositoryAssociationRepositoryCodecommit? = null,
    public val githubEnterpriseServer: RepositoryAssociationRepositoryGithubEnterpriseServer? = null,
    public val s3Bucket: RepositoryAssociationRepositoryS3Bucket? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codegurureviewer.outputs.RepositoryAssociationRepository): RepositoryAssociationRepository = RepositoryAssociationRepository(
            bitbucket = javaType.bitbucket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepositoryBitbucket.Companion.toKotlin(args0)
                })
            }).orElse(null),
            codecommit = javaType.codecommit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepositoryCodecommit.Companion.toKotlin(args0)
                })
            }).orElse(null),
            githubEnterpriseServer = javaType.githubEnterpriseServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepositoryGithubEnterpriseServer.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Bucket = javaType.s3Bucket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codegurureviewer.kotlin.outputs.RepositoryAssociationRepositoryS3Bucket.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
