@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.CustomActionTypeArgs.builder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeConfigurationPropertyArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeConfigurationPropertyArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeInputArtifactDetailsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeInputArtifactDetailsArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeOutputArtifactDetailsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeOutputArtifactDetailsArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeSettingsArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.CustomActionTypeSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeDeploy CustomActionType
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codepipeline.CustomActionType("example", {
 *     category: "Build",
 *     inputArtifactDetails: {
 *         maximumCount: 1,
 *         minimumCount: 0,
 *     },
 *     outputArtifactDetails: {
 *         maximumCount: 1,
 *         minimumCount: 0,
 *     },
 *     providerName: "example",
 *     version: "1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codepipeline.CustomActionType("example",
 *     category="Build",
 *     input_artifact_details={
 *         "maximum_count": 1,
 *         "minimum_count": 0,
 *     },
 *     output_artifact_details={
 *         "maximum_count": 1,
 *         "minimum_count": 0,
 *     },
 *     provider_name="example",
 *     version="1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodePipeline.CustomActionType("example", new()
 *     {
 *         Category = "Build",
 *         InputArtifactDetails = new Aws.CodePipeline.Inputs.CustomActionTypeInputArtifactDetailsArgs
 *         {
 *             MaximumCount = 1,
 *             MinimumCount = 0,
 *         },
 *         OutputArtifactDetails = new Aws.CodePipeline.Inputs.CustomActionTypeOutputArtifactDetailsArgs
 *         {
 *             MaximumCount = 1,
 *             MinimumCount = 0,
 *         },
 *         ProviderName = "example",
 *         Version = "1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codepipeline"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codepipeline.NewCustomActionType(ctx, "example", &codepipeline.CustomActionTypeArgs{
 * 			Category: pulumi.String("Build"),
 * 			InputArtifactDetails: &codepipeline.CustomActionTypeInputArtifactDetailsArgs{
 * 				MaximumCount: pulumi.Int(1),
 * 				MinimumCount: pulumi.Int(0),
 * 			},
 * 			OutputArtifactDetails: &codepipeline.CustomActionTypeOutputArtifactDetailsArgs{
 * 				MaximumCount: pulumi.Int(1),
 * 				MinimumCount: pulumi.Int(0),
 * 			},
 * 			ProviderName: pulumi.String("example"),
 * 			Version:      pulumi.String("1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codepipeline.CustomActionType;
 * import com.pulumi.aws.codepipeline.CustomActionTypeArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeInputArtifactDetailsArgs;
 * import com.pulumi.aws.codepipeline.inputs.CustomActionTypeOutputArtifactDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomActionType("example", CustomActionTypeArgs.builder()
 *             .category("Build")
 *             .inputArtifactDetails(CustomActionTypeInputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .outputArtifactDetails(CustomActionTypeOutputArtifactDetailsArgs.builder()
 *                 .maximumCount(1)
 *                 .minimumCount(0)
 *                 .build())
 *             .providerName("example")
 *             .version("1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codepipeline:CustomActionType
 *     properties:
 *       category: Build
 *       inputArtifactDetails:
 *         maximumCount: 1
 *         minimumCount: 0
 *       outputArtifactDetails:
 *         maximumCount: 1
 *         minimumCount: 0
 *       providerName: example
 *       version: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeDeploy CustomActionType using the `id`. For example:
 * ```sh
 * $ pulumi import aws:codepipeline/customActionType:CustomActionType example Build:pulumi:1
 * ```
 * @property category The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
 * @property configurationProperties The configuration properties for the custom action. Max 10 items.
 * @property inputArtifactDetails
 * @property outputArtifactDetails
 * @property providerName
 * @property settings
 * @property tags
 * @property version
 */
public data class CustomActionTypeArgs(
    public val category: Output<String>? = null,
    public val configurationProperties: Output<List<CustomActionTypeConfigurationPropertyArgs>>? =
        null,
    public val inputArtifactDetails: Output<CustomActionTypeInputArtifactDetailsArgs>? = null,
    public val outputArtifactDetails: Output<CustomActionTypeOutputArtifactDetailsArgs>? = null,
    public val providerName: Output<String>? = null,
    public val settings: Output<CustomActionTypeSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.CustomActionTypeArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.CustomActionTypeArgs =
        com.pulumi.aws.codepipeline.CustomActionTypeArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .configurationProperties(
                configurationProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputArtifactDetails(
                inputArtifactDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputArtifactDetails(
                outputArtifactDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomActionTypeArgs].
 */
@PulumiTagMarker
public class CustomActionTypeArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var configurationProperties: Output<List<CustomActionTypeConfigurationPropertyArgs>>? =
        null

    private var inputArtifactDetails: Output<CustomActionTypeInputArtifactDetailsArgs>? = null

    private var outputArtifactDetails: Output<CustomActionTypeOutputArtifactDetailsArgs>? = null

    private var providerName: Output<String>? = null

    private var settings: Output<CustomActionTypeSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
     */
    @JvmName("xxdfokyhycojafis")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("ypddvismqvdidaiv")
    public suspend fun configurationProperties(`value`: Output<List<CustomActionTypeConfigurationPropertyArgs>>) {
        this.configurationProperties = value
    }

    @JvmName("yjcnltlmgedhtcuq")
    public suspend fun configurationProperties(vararg values: Output<CustomActionTypeConfigurationPropertyArgs>) {
        this.configurationProperties = Output.all(values.asList())
    }

    /**
     * @param values The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("ufnvesldoaiqurgr")
    public suspend fun configurationProperties(values: List<Output<CustomActionTypeConfigurationPropertyArgs>>) {
        this.configurationProperties = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("jvfcdiancxkcamql")
    public suspend fun inputArtifactDetails(`value`: Output<CustomActionTypeInputArtifactDetailsArgs>) {
        this.inputArtifactDetails = value
    }

    /**
     * @param value
     */
    @JvmName("junwmvylpfbdkecf")
    public suspend fun outputArtifactDetails(`value`: Output<CustomActionTypeOutputArtifactDetailsArgs>) {
        this.outputArtifactDetails = value
    }

    /**
     * @param value
     */
    @JvmName("tkwlpkgkjgvnnneo")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value
     */
    @JvmName("wffkwwbwnsjmhnrf")
    public suspend fun settings(`value`: Output<CustomActionTypeSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value
     */
    @JvmName("xajlmbgsvdtaksvr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("lgnmcmngcgtnqtkm")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The category of the custom action. Valid values: `Source`, `Build`, `Deploy`, `Test`, `Invoke`, `Approval`
     */
    @JvmName("xgqajvqywhhqvvsy")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("ddrxjtxooounmlrm")
    public suspend fun configurationProperties(`value`: List<CustomActionTypeConfigurationPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("rwauvvewatmgvris")
    public suspend fun configurationProperties(argument: List<suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("gbktdflitgiptswo")
    public suspend fun configurationProperties(vararg argument: suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param argument The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("ldkgcihxrddctrkx")
    public suspend fun configurationProperties(argument: suspend CustomActionTypeConfigurationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomActionTypeConfigurationPropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurationProperties = mapped
    }

    /**
     * @param values The configuration properties for the custom action. Max 10 items.
     */
    @JvmName("icwbdltuehwogsbf")
    public suspend fun configurationProperties(vararg values: CustomActionTypeConfigurationPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationProperties = mapped
    }

    /**
     * @param value
     */
    @JvmName("uaiymfokirvbntqa")
    public suspend fun inputArtifactDetails(`value`: CustomActionTypeInputArtifactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputArtifactDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sreamlkvfvegojht")
    public suspend fun inputArtifactDetails(argument: suspend CustomActionTypeInputArtifactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeInputArtifactDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputArtifactDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("hvbrbohfnbmtjrba")
    public suspend fun outputArtifactDetails(`value`: CustomActionTypeOutputArtifactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputArtifactDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gpxgmlhcbuqsxtei")
    public suspend fun outputArtifactDetails(argument: suspend CustomActionTypeOutputArtifactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeOutputArtifactDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outputArtifactDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("bikdppqtppiofkfd")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ultkyoxtnpmvufvc")
    public suspend fun settings(`value`: CustomActionTypeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qkvmncumvumwbxmx")
    public suspend fun settings(argument: suspend CustomActionTypeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActionTypeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value
     */
    @JvmName("vajutatpyptcjcdw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("thskhllsqwbwmveo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hdkriqnluwadkhyd")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): CustomActionTypeArgs = CustomActionTypeArgs(
        category = category,
        configurationProperties = configurationProperties,
        inputArtifactDetails = inputArtifactDetails,
        outputArtifactDetails = outputArtifactDetails,
        providerName = providerName,
        settings = settings,
        tags = tags,
        version = version,
    )
}
