@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.kotlin.outputs.WebhookAuthenticationConfiguration
import com.pulumi.aws.codepipeline.kotlin.outputs.WebhookFilter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codepipeline.kotlin.outputs.WebhookAuthenticationConfiguration.Companion.toKotlin as webhookAuthenticationConfigurationToKotlin
import com.pulumi.aws.codepipeline.kotlin.outputs.WebhookFilter.Companion.toKotlin as webhookFilterToKotlin

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource = com.pulumi.aws.codepipeline.Webhook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Webhook(builtJavaResource)
    }
}

/**
 * Provides a CodePipeline Webhook.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:codepipeline:Pipeline
 *     properties:
 *       name: tf-test-pipeline
 *       roleArn: ${barAwsIamRole.arn}
 *       artifactStores:
 *         - location: ${barAwsS3Bucket.bucket}
 *           type: S3
 *           encryptionKey:
 *             id: ${s3kmskey.arn}
 *             type: KMS
 *       stages:
 *         - name: Source
 *           actions:
 *             - name: Source
 *               category: Source
 *               owner: ThirdParty
 *               provider: GitHub
 *               version: '1'
 *               outputArtifacts:
 *                 - test
 *               configuration:
 *                 Owner: my-organization
 *                 Repo: test
 *                 Branch: master
 *         - name: Build
 *           actions:
 *             - name: Build
 *               category: Build
 *               owner: AWS
 *               provider: CodeBuild
 *               inputArtifacts:
 *                 - test
 *               version: '1'
 *               configuration:
 *                 ProjectName: test
 *   barWebhook:
 *     type: aws:codepipeline:Webhook
 *     name: bar
 *     properties:
 *       name: test-webhook-github-bar
 *       authentication: GITHUB_HMAC
 *       targetAction: Source
 *       targetPipeline: ${bar.name}
 *       authenticationConfiguration:
 *         secretToken: ${webhookSecret}
 *       filters:
 *         - jsonPath: $.ref
 *           matchEquals: refs/heads/{Branch}
 *   # Wire the CodePipeline webhook into a GitHub repository.
 *   barRepositoryWebhook:
 *     type: github:RepositoryWebhook
 *     name: bar
 *     properties:
 *       repository: ${repo.name}
 *       name: web
 *       configuration:
 *         url: ${barWebhook.url}
 *         contentType: json
 *         insecureSsl: true
 *         secret: ${webhookSecret}
 *       events:
 *         - push
 * variables:
 *   webhookSecret: super-secret
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodePipeline Webhooks using their ARN. For example:
 * ```sh
 * $ pulumi import aws:codepipeline/webhook:Webhook example arn:aws:codepipeline:us-west-2:123456789012:webhook:example
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.aws.codepipeline.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * The CodePipeline webhook's ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
     */
    public val authentication: Output<String>
        get() = javaResource.authentication().applyValue({ args0 -> args0 })

    /**
     * An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    public val authenticationConfiguration: Output<WebhookAuthenticationConfiguration>?
        get() = javaResource.authenticationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webhookAuthenticationConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * One or more `filter` blocks. Filter blocks are documented below.
     */
    public val filters: Output<List<WebhookFilter>>
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webhookFilterToKotlin(args0)
                })
            })
        })

    /**
     * The name of the webhook.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
     */
    public val targetAction: Output<String>
        get() = javaResource.targetAction().applyValue({ args0 -> args0 })

    /**
     * The name of the pipeline.
     */
    public val targetPipeline: Output<String>
        get() = javaResource.targetPipeline().applyValue({ args0 -> args0 })

    /**
     * The CodePipeline webhook's URL. POST events to this endpoint to trigger the target.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codepipeline.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.aws.codepipeline.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
