@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin

import com.pulumi.aws.codepipeline.WebhookArgs.builder
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookAuthenticationConfigurationArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookAuthenticationConfigurationArgsBuilder
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookFilterArgs
import com.pulumi.aws.codepipeline.kotlin.inputs.WebhookFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodePipeline Webhook.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:codepipeline:Pipeline
 *     properties:
 *       name: tf-test-pipeline
 *       roleArn: ${barAwsIamRole.arn}
 *       artifactStores:
 *         - location: ${barAwsS3Bucket.bucket}
 *           type: S3
 *           encryptionKey:
 *             id: ${s3kmskey.arn}
 *             type: KMS
 *       stages:
 *         - name: Source
 *           actions:
 *             - name: Source
 *               category: Source
 *               owner: ThirdParty
 *               provider: GitHub
 *               version: '1'
 *               outputArtifacts:
 *                 - test
 *               configuration:
 *                 Owner: my-organization
 *                 Repo: test
 *                 Branch: master
 *         - name: Build
 *           actions:
 *             - name: Build
 *               category: Build
 *               owner: AWS
 *               provider: CodeBuild
 *               inputArtifacts:
 *                 - test
 *               version: '1'
 *               configuration:
 *                 ProjectName: test
 *   barWebhook:
 *     type: aws:codepipeline:Webhook
 *     name: bar
 *     properties:
 *       name: test-webhook-github-bar
 *       authentication: GITHUB_HMAC
 *       targetAction: Source
 *       targetPipeline: ${bar.name}
 *       authenticationConfiguration:
 *         secretToken: ${webhookSecret}
 *       filters:
 *         - jsonPath: $.ref
 *           matchEquals: refs/heads/{Branch}
 *   # Wire the CodePipeline webhook into a GitHub repository.
 *   barRepositoryWebhook:
 *     type: github:RepositoryWebhook
 *     name: bar
 *     properties:
 *       repository: ${repo.name}
 *       name: web
 *       configuration:
 *         url: ${barWebhook.url}
 *         contentType: json
 *         insecureSsl: true
 *         secret: ${webhookSecret}
 *       events:
 *         - push
 * variables:
 *   webhookSecret: super-secret
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodePipeline Webhooks using their ARN. For example:
 * ```sh
 * $ pulumi import aws:codepipeline/webhook:Webhook example arn:aws:codepipeline:us-west-2:123456789012:webhook:example
 * ```
 * @property authentication The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
 * @property authenticationConfiguration An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
 * @property filters One or more `filter` blocks. Filter blocks are documented below.
 * @property name The name of the webhook.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetAction The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
 * @property targetPipeline The name of the pipeline.
 */
public data class WebhookArgs(
    public val authentication: Output<String>? = null,
    public val authenticationConfiguration: Output<WebhookAuthenticationConfigurationArgs>? = null,
    public val filters: Output<List<WebhookFilterArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetAction: Output<String>? = null,
    public val targetPipeline: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.WebhookArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.WebhookArgs =
        com.pulumi.aws.codepipeline.WebhookArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetAction(targetAction?.applyValue({ args0 -> args0 }))
            .targetPipeline(targetPipeline?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var authentication: Output<String>? = null

    private var authenticationConfiguration: Output<WebhookAuthenticationConfigurationArgs>? = null

    private var filters: Output<List<WebhookFilterArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetAction: Output<String>? = null

    private var targetPipeline: Output<String>? = null

    /**
     * @param value The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
     */
    @JvmName("jbgljhwlrmewpjvf")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("ovotonrxnshfymff")
    public suspend fun authenticationConfiguration(`value`: Output<WebhookAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("njyseckclirnavaj")
    public suspend fun filters(`value`: Output<List<WebhookFilterArgs>>) {
        this.filters = value
    }

    @JvmName("havtctpyilqtluyc")
    public suspend fun filters(vararg values: Output<WebhookFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("soibpbpscedfvrrx")
    public suspend fun filters(values: List<Output<WebhookFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("solxbtqrwpanasxv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sprbesdrgrfteltn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
     */
    @JvmName("aqwwdfuggutcgqni")
    public suspend fun targetAction(`value`: Output<String>) {
        this.targetAction = value
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("hgfeimydrbqqlehc")
    public suspend fun targetPipeline(`value`: Output<String>) {
        this.targetPipeline = value
    }

    /**
     * @param value The type of authentication  to use. One of `IP`, `GITHUB_HMAC`, or `UNAUTHENTICATED`.
     */
    @JvmName("aqslghsrqdyoqeql")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("rmfyswmaloxsxxwd")
    public suspend fun authenticationConfiguration(`value`: WebhookAuthenticationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument An `auth` block. Required for `IP` and `GITHUB_HMAC`. Auth blocks are documented below.
     */
    @JvmName("raucpxtxcovhswfh")
    public suspend fun authenticationConfiguration(argument: suspend WebhookAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebhookAuthenticationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("nqytgovmtwkxbbtm")
    public suspend fun filters(`value`: List<WebhookFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("cregjxcfdwfgtdkv")
    public suspend fun filters(argument: List<suspend WebhookFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("inoqbrvobupdaqki")
    public suspend fun filters(vararg argument: suspend WebhookFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("oivimwybythvkupo")
    public suspend fun filters(argument: suspend WebhookFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values One or more `filter` blocks. Filter blocks are documented below.
     */
    @JvmName("ajpyyptkfigvldev")
    public suspend fun filters(vararg values: WebhookFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("ipuaywhsxcjahagf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("crswresurffnyctd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("njmckmrdoduvjbrq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.
     */
    @JvmName("eabnlpbsgpqywwsr")
    public suspend fun targetAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAction = mapped
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("qlsilhifinjsrwsq")
    public suspend fun targetPipeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPipeline = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        authentication = authentication,
        authenticationConfiguration = authenticationConfiguration,
        filters = filters,
        name = name,
        tags = tags,
        targetAction = targetAction,
        targetPipeline = targetPipeline,
    )
}
