@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The KMS key ARN or ID
 * @property type The type of key; currently only `KMS` is supported
 */
public data class PipelineArtifactStoreEncryptionKeyArgs(
    public val id: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreEncryptionKeyArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineArtifactStoreEncryptionKeyArgs].
 */
@PulumiTagMarker
public class PipelineArtifactStoreEncryptionKeyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The KMS key ARN or ID
     */
    @JvmName("byqfdwajujpkpubm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The type of key; currently only `KMS` is supported
     */
    @JvmName("aaapwyayjajxqfxn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The KMS key ARN or ID
     */
    @JvmName("flugkgxbtjanjqcl")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The type of key; currently only `KMS` is supported
     */
    @JvmName("enrwptcihwaafplq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineArtifactStoreEncryptionKeyArgs =
        PipelineArtifactStoreEncryptionKeyArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
