@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions The action(s) to include in the stage. Defined as an `action` block below
 * @property name The name of the stage.
 */
public data class PipelineStageArgs(
    public val actions: Output<List<PipelineStageActionArgs>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineStageArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineStageArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineStageArgs.builder()
            .actions(
                actions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineStageArgs].
 */
@PulumiTagMarker
public class PipelineStageArgsBuilder internal constructor() {
    private var actions: Output<List<PipelineStageActionArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("htkjorhfltcjbnlr")
    public suspend fun actions(`value`: Output<List<PipelineStageActionArgs>>) {
        this.actions = value
    }

    @JvmName("huujimakslnauofi")
    public suspend fun actions(vararg values: Output<PipelineStageActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("tgtcxmnvfxunklyw")
    public suspend fun actions(values: List<Output<PipelineStageActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The name of the stage.
     */
    @JvmName("uowdukmcduwxujti")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("gmgtpmmvqysfufji")
    public suspend fun actions(`value`: List<PipelineStageActionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("ldjcnryhcjhpawyb")
    public suspend fun actions(argument: List<suspend PipelineStageActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineStageActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("abfstuwvvesmnaxh")
    public suspend fun actions(vararg argument: suspend PipelineStageActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineStageActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("immgybbpiplxpobh")
    public suspend fun actions(argument: suspend PipelineStageActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PipelineStageActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values The action(s) to include in the stage. Defined as an `action` block below
     */
    @JvmName("ynfrhoacaimfoaft")
    public suspend fun actions(vararg values: PipelineStageActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The name of the stage.
     */
    @JvmName("ijjuymvrjdmldtpe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PipelineStageArgs = PipelineStageArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
