@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
 * @property providerType The source provider for the event. Possible value is `CodeStarSourceConnection`.
 */
public data class PipelineTriggerArgs(
    public val gitConfiguration: Output<PipelineTriggerGitConfigurationArgs>,
    public val providerType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineTriggerArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineTriggerArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineTriggerArgs.builder()
            .gitConfiguration(gitConfiguration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerType(providerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineTriggerArgs].
 */
@PulumiTagMarker
public class PipelineTriggerArgsBuilder internal constructor() {
    private var gitConfiguration: Output<PipelineTriggerGitConfigurationArgs>? = null

    private var providerType: Output<String>? = null

    /**
     * @param value Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
     */
    @JvmName("ljvujhsrwxidabvc")
    public suspend fun gitConfiguration(`value`: Output<PipelineTriggerGitConfigurationArgs>) {
        this.gitConfiguration = value
    }

    /**
     * @param value The source provider for the event. Possible value is `CodeStarSourceConnection`.
     */
    @JvmName("rychjbslwbkrouth")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
     */
    @JvmName("aianstwafruvnxgj")
    public suspend fun gitConfiguration(`value`: PipelineTriggerGitConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitConfiguration = mapped
    }

    /**
     * @param argument Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
     */
    @JvmName("divlxgakwywoifrc")
    public suspend fun gitConfiguration(argument: suspend PipelineTriggerGitConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitConfiguration = mapped
    }

    /**
     * @param value The source provider for the event. Possible value is `CodeStarSourceConnection`.
     */
    @JvmName("nyvlvwwuhbnpxkyd")
    public suspend fun providerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    internal fun build(): PipelineTriggerArgs = PipelineTriggerArgs(
        gitConfiguration = gitConfiguration ?: throw PulumiNullFieldException("gitConfiguration"),
        providerType = providerType ?: throw PulumiNullFieldException("providerType"),
    )
}
