@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pullRequests The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
 * @property pushes The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
 * @property sourceActionName The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
 */
public data class PipelineTriggerGitConfigurationArgs(
    public val pullRequests: Output<List<PipelineTriggerGitConfigurationPullRequestArgs>>? = null,
    public val pushes: Output<List<PipelineTriggerGitConfigurationPushArgs>>? = null,
    public val sourceActionName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationArgs.builder()
            .pullRequests(
                pullRequests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pushes(pushes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sourceActionName(sourceActionName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineTriggerGitConfigurationArgs].
 */
@PulumiTagMarker
public class PipelineTriggerGitConfigurationArgsBuilder internal constructor() {
    private var pullRequests: Output<List<PipelineTriggerGitConfigurationPullRequestArgs>>? = null

    private var pushes: Output<List<PipelineTriggerGitConfigurationPushArgs>>? = null

    private var sourceActionName: Output<String>? = null

    /**
     * @param value The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("jmcegkscfruoiqvo")
    public suspend fun pullRequests(`value`: Output<List<PipelineTriggerGitConfigurationPullRequestArgs>>) {
        this.pullRequests = value
    }

    @JvmName("nixxsaatmbcwsxlo")
    public suspend fun pullRequests(vararg values: Output<PipelineTriggerGitConfigurationPullRequestArgs>) {
        this.pullRequests = Output.all(values.asList())
    }

    /**
     * @param values The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("yebjcpnrlghbhofv")
    public suspend fun pullRequests(values: List<Output<PipelineTriggerGitConfigurationPullRequestArgs>>) {
        this.pullRequests = Output.all(values)
    }

    /**
     * @param value The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("ammeclalipxinxuw")
    public suspend fun pushes(`value`: Output<List<PipelineTriggerGitConfigurationPushArgs>>) {
        this.pushes = value
    }

    @JvmName("tupkkhflbplnydsg")
    public suspend fun pushes(vararg values: Output<PipelineTriggerGitConfigurationPushArgs>) {
        this.pushes = Output.all(values.asList())
    }

    /**
     * @param values The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("dnpjuslbyputkyvd")
    public suspend fun pushes(values: List<Output<PipelineTriggerGitConfigurationPushArgs>>) {
        this.pushes = Output.all(values)
    }

    /**
     * @param value The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
     */
    @JvmName("liwyrpmbfdfgxoky")
    public suspend fun sourceActionName(`value`: Output<String>) {
        this.sourceActionName = value
    }

    /**
     * @param value The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("tjorcgjvmkvpgdqo")
    public suspend fun pullRequests(`value`: List<PipelineTriggerGitConfigurationPullRequestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullRequests = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("bkwsgclwmmlfapkd")
    public suspend fun pullRequests(argument: List<suspend PipelineTriggerGitConfigurationPullRequestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineTriggerGitConfigurationPullRequestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pullRequests = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("tcovociwxxliocqc")
    public suspend fun pullRequests(vararg argument: suspend PipelineTriggerGitConfigurationPullRequestArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineTriggerGitConfigurationPullRequestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pullRequests = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("vxabewoiwnhmnunf")
    public suspend fun pullRequests(argument: suspend PipelineTriggerGitConfigurationPullRequestArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineTriggerGitConfigurationPullRequestArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pullRequests = mapped
    }

    /**
     * @param values The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
     */
    @JvmName("qjlyqogmaytknnwn")
    public suspend fun pullRequests(vararg values: PipelineTriggerGitConfigurationPullRequestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pullRequests = mapped
    }

    /**
     * @param value The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("xctpbixwcjqfmbyi")
    public suspend fun pushes(`value`: List<PipelineTriggerGitConfigurationPushArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushes = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("fmxldtvpcbainivu")
    public suspend fun pushes(argument: List<suspend PipelineTriggerGitConfigurationPushArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineTriggerGitConfigurationPushArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pushes = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("ebqnllnvkggmjidw")
    public suspend fun pushes(vararg argument: suspend PipelineTriggerGitConfigurationPushArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineTriggerGitConfigurationPushArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pushes = mapped
    }

    /**
     * @param argument The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("nnofffqwnwjhrrev")
    public suspend fun pushes(argument: suspend PipelineTriggerGitConfigurationPushArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineTriggerGitConfigurationPushArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pushes = mapped
    }

    /**
     * @param values The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
     */
    @JvmName("ucjpsmcsipmdicoa")
    public suspend fun pushes(vararg values: PipelineTriggerGitConfigurationPushArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pushes = mapped
    }

    /**
     * @param value The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
     */
    @JvmName("biuegbpbcswhctue")
    public suspend fun sourceActionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceActionName = mapped
    }

    internal fun build(): PipelineTriggerGitConfigurationArgs = PipelineTriggerGitConfigurationArgs(
        pullRequests = pullRequests,
        pushes = pushes,
        sourceActionName = sourceActionName ?: throw PulumiNullFieldException("sourceActionName"),
    )
}
