@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPullRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property branches The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
 * @property events A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
 * @property filePaths The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
 */
public data class PipelineTriggerGitConfigurationPullRequestArgs(
    public val branches: Output<PipelineTriggerGitConfigurationPullRequestBranchesArgs>? = null,
    public val events: Output<List<String>>? = null,
    public val filePaths: Output<PipelineTriggerGitConfigurationPullRequestFilePathsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPullRequestArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPullRequestArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPullRequestArgs.builder()
            .branches(branches?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filePaths(filePaths?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineTriggerGitConfigurationPullRequestArgs].
 */
@PulumiTagMarker
public class PipelineTriggerGitConfigurationPullRequestArgsBuilder internal constructor() {
    private var branches: Output<PipelineTriggerGitConfigurationPullRequestBranchesArgs>? = null

    private var events: Output<List<String>>? = null

    private var filePaths: Output<PipelineTriggerGitConfigurationPullRequestFilePathsArgs>? = null

    /**
     * @param value The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
     */
    @JvmName("wgitrqytftmyuwjy")
    public suspend fun branches(`value`: Output<PipelineTriggerGitConfigurationPullRequestBranchesArgs>) {
        this.branches = value
    }

    /**
     * @param value A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
     */
    @JvmName("xnpbqshfintkvtcc")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("eikivkossrviquqj")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
     */
    @JvmName("tykeqavtbtvsfqed")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("xqiwgtllfvlhfmak")
    public suspend fun filePaths(`value`: Output<PipelineTriggerGitConfigurationPullRequestFilePathsArgs>) {
        this.filePaths = value
    }

    /**
     * @param value The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
     */
    @JvmName("fciyklhurxmrfuhm")
    public suspend fun branches(`value`: PipelineTriggerGitConfigurationPullRequestBranchesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param argument The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
     */
    @JvmName("frexslgflsckkrkn")
    public suspend fun branches(argument: suspend PipelineTriggerGitConfigurationPullRequestBranchesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationPullRequestBranchesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.branches = mapped
    }

    /**
     * @param value A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
     */
    @JvmName("hxpewtarhjhwvvmp")
    public suspend fun events(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
     */
    @JvmName("sedglisgtcbtkibl")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("omrfrmdksxkgicyv")
    public suspend fun filePaths(`value`: PipelineTriggerGitConfigurationPullRequestFilePathsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param argument The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("aagvoeduvtwcatpq")
    public suspend fun filePaths(argument: suspend PipelineTriggerGitConfigurationPullRequestFilePathsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationPullRequestFilePathsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filePaths = mapped
    }

    internal fun build(): PipelineTriggerGitConfigurationPullRequestArgs =
        PipelineTriggerGitConfigurationPullRequestArgs(
            branches = branches,
            events = events,
            filePaths = filePaths,
        )
}
