@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property branches The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
 * @property filePaths The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
 * @property tags The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
 */
public data class PipelineTriggerGitConfigurationPushArgs(
    public val branches: Output<PipelineTriggerGitConfigurationPushBranchesArgs>? = null,
    public val filePaths: Output<PipelineTriggerGitConfigurationPushFilePathsArgs>? = null,
    public val tags: Output<PipelineTriggerGitConfigurationPushTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushArgs = com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushArgs.builder()
        .branches(branches?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .filePaths(filePaths?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineTriggerGitConfigurationPushArgs].
 */
@PulumiTagMarker
public class PipelineTriggerGitConfigurationPushArgsBuilder internal constructor() {
    private var branches: Output<PipelineTriggerGitConfigurationPushBranchesArgs>? = null

    private var filePaths: Output<PipelineTriggerGitConfigurationPushFilePathsArgs>? = null

    private var tags: Output<PipelineTriggerGitConfigurationPushTagsArgs>? = null

    /**
     * @param value The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
     */
    @JvmName("rpwmldjvdgppdfkd")
    public suspend fun branches(`value`: Output<PipelineTriggerGitConfigurationPushBranchesArgs>) {
        this.branches = value
    }

    /**
     * @param value The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("djifykhbdbwhnysm")
    public suspend fun filePaths(`value`: Output<PipelineTriggerGitConfigurationPushFilePathsArgs>) {
        this.filePaths = value
    }

    /**
     * @param value The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
     */
    @JvmName("mxufpdyrbjjnrkan")
    public suspend fun tags(`value`: Output<PipelineTriggerGitConfigurationPushTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
     */
    @JvmName("brxernuuosbftrpl")
    public suspend fun branches(`value`: PipelineTriggerGitConfigurationPushBranchesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param argument The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
     */
    @JvmName("apirormboanjeonm")
    public suspend fun branches(argument: suspend PipelineTriggerGitConfigurationPushBranchesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationPushBranchesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.branches = mapped
    }

    /**
     * @param value The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("nctpsdolfibewxhg")
    public suspend fun filePaths(`value`: PipelineTriggerGitConfigurationPushFilePathsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param argument The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
     */
    @JvmName("gnmghraeqaerkxtl")
    public suspend fun filePaths(argument: suspend PipelineTriggerGitConfigurationPushFilePathsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationPushFilePathsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filePaths = mapped
    }

    /**
     * @param value The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
     */
    @JvmName("akwjiajgtsbncmek")
    public suspend fun tags(`value`: PipelineTriggerGitConfigurationPushTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
     */
    @JvmName("pqkpugtleqfjarts")
    public suspend fun tags(argument: suspend PipelineTriggerGitConfigurationPushTagsArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineTriggerGitConfigurationPushTagsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): PipelineTriggerGitConfigurationPushArgs =
        PipelineTriggerGitConfigurationPushArgs(
            branches = branches,
            filePaths = filePaths,
            tags = tags,
        )
}
