@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushBranchesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property excludes A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
 * @property includes A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
 */
public data class PipelineTriggerGitConfigurationPushBranchesArgs(
    public val excludes: Output<List<String>>? = null,
    public val includes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushBranchesArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushBranchesArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineTriggerGitConfigurationPushBranchesArgs.builder()
            .excludes(excludes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includes(includes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PipelineTriggerGitConfigurationPushBranchesArgs].
 */
@PulumiTagMarker
public class PipelineTriggerGitConfigurationPushBranchesArgsBuilder internal constructor() {
    private var excludes: Output<List<String>>? = null

    private var includes: Output<List<String>>? = null

    /**
     * @param value A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
     */
    @JvmName("aaeabboemdijjccg")
    public suspend fun excludes(`value`: Output<List<String>>) {
        this.excludes = value
    }

    @JvmName("kgjemweuicowtrmh")
    public suspend fun excludes(vararg values: Output<String>) {
        this.excludes = Output.all(values.asList())
    }

    /**
     * @param values A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
     */
    @JvmName("wfosmxgddwghodxd")
    public suspend fun excludes(values: List<Output<String>>) {
        this.excludes = Output.all(values)
    }

    /**
     * @param value A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
     */
    @JvmName("flglwhliuqttudyn")
    public suspend fun includes(`value`: Output<List<String>>) {
        this.includes = value
    }

    @JvmName("qcetqxaoorqosxho")
    public suspend fun includes(vararg values: Output<String>) {
        this.includes = Output.all(values.asList())
    }

    /**
     * @param values A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
     */
    @JvmName("hcinqyqkfdwciubl")
    public suspend fun includes(values: List<Output<String>>) {
        this.includes = Output.all(values)
    }

    /**
     * @param value A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
     */
    @JvmName("ghrksqjpgpliticf")
    public suspend fun excludes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludes = mapped
    }

    /**
     * @param values A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
     */
    @JvmName("jdqegwiwyxlypgxg")
    public suspend fun excludes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludes = mapped
    }

    /**
     * @param value A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
     */
    @JvmName("ulmbdopvcegvtjav")
    public suspend fun includes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includes = mapped
    }

    /**
     * @param values A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
     */
    @JvmName("afgsvsdqnvoivmud")
    public suspend fun includes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includes = mapped
    }

    internal fun build(): PipelineTriggerGitConfigurationPushBranchesArgs =
        PipelineTriggerGitConfigurationPushBranchesArgs(
            excludes = excludes,
            includes = includes,
        )
}
