@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.inputs

import com.pulumi.aws.codepipeline.inputs.PipelineVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultValue The default value of a pipeline-level variable.
 * @property description The description of a pipeline-level variable.
 * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
 * @property name The name of a pipeline-level variable.
 */
public data class PipelineVariableArgs(
    public val defaultValue: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codepipeline.inputs.PipelineVariableArgs> {
    override fun toJava(): com.pulumi.aws.codepipeline.inputs.PipelineVariableArgs =
        com.pulumi.aws.codepipeline.inputs.PipelineVariableArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineVariableArgs].
 */
@PulumiTagMarker
public class PipelineVariableArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The default value of a pipeline-level variable.
     */
    @JvmName("uigjrqiseppapnoe")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value The description of a pipeline-level variable.
     * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     */
    @JvmName("gdtgphtktufpamwu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of a pipeline-level variable.
     */
    @JvmName("kwvglsmllyrwhgpf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The default value of a pipeline-level variable.
     */
    @JvmName("sqcmhoumqpuevdmi")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value The description of a pipeline-level variable.
     * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     */
    @JvmName("uxbkkawibqweydnr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of a pipeline-level variable.
     */
    @JvmName("htjvegvgarmbaett")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PipelineVariableArgs = PipelineVariableArgs(
        defaultValue = defaultValue,
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
