@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the action configuration property.
 * @property key Whether the configuration property is a key.
 * @property name The name of the action configuration property.
 * @property queryable Indicates that the property will be used in conjunction with PollForJobs.
 * @property required Whether the configuration property is a required value.
 * @property secret Whether the configuration property is secret.
 * @property type The type of the configuration property. Valid values: `String`, `Number`, `Boolean`
 */
public data class CustomActionTypeConfigurationProperty(
    public val description: String? = null,
    public val key: Boolean,
    public val name: String,
    public val queryable: Boolean? = null,
    public val required: Boolean,
    public val secret: Boolean,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.CustomActionTypeConfigurationProperty): CustomActionTypeConfigurationProperty = CustomActionTypeConfigurationProperty(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
            name = javaType.name(),
            queryable = javaType.queryable().map({ args0 -> args0 }).orElse(null),
            required = javaType.required(),
            secret = javaType.secret(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
