@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The KMS key ARN or ID
 * @property type The type of key; currently only `KMS` is supported
 */
public data class PipelineArtifactStoreEncryptionKey(
    public val id: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineArtifactStoreEncryptionKey): PipelineArtifactStoreEncryptionKey = PipelineArtifactStoreEncryptionKey(
            id = javaType.id(),
            type = javaType.type(),
        )
    }
}
