@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-filter.html). A `git_configuration` block is documented below.
 * @property providerType The source provider for the event. Possible value is `CodeStarSourceConnection`.
 */
public data class PipelineTrigger(
    public val gitConfiguration: PipelineTriggerGitConfiguration,
    public val providerType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineTrigger): PipelineTrigger = PipelineTrigger(
            gitConfiguration = javaType.gitConfiguration().let({ args0 ->
                com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfiguration.Companion.toKotlin(args0)
            }),
            providerType = javaType.providerType(),
        )
    }
}
