@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property pullRequests The field where the repository event that will start the pipeline is specified as pull requests. A `pull_request` block is documented below.
 * @property pushes The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details. A `push` block is documented below.
 * @property sourceActionName The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The trigger configuration will start the pipeline upon the specified change only.
 */
public data class PipelineTriggerGitConfiguration(
    public val pullRequests: List<PipelineTriggerGitConfigurationPullRequest>? = null,
    public val pushes: List<PipelineTriggerGitConfigurationPush>? = null,
    public val sourceActionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineTriggerGitConfiguration): PipelineTriggerGitConfiguration = PipelineTriggerGitConfiguration(
            pullRequests = javaType.pullRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPullRequest.Companion.toKotlin(args0)
                })
            }),
            pushes = javaType.pushes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPush.Companion.toKotlin(args0)
                })
            }),
            sourceActionName = javaType.sourceActionName(),
        )
    }
}
