@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property branches The field that specifies to filter on branches for the pull request trigger configuration. A `branches` block is documented below.
 * @property events A list that specifies which pull request events to filter on (opened, updated, closed) for the trigger configuration. Possible values are `OPEN`, `UPDATED ` and `CLOSED`.
 * @property filePaths The field that specifies to filter on file paths for the pull request trigger configuration. A `file_paths` block is documented below.
 */
public data class PipelineTriggerGitConfigurationPullRequest(
    public val branches: PipelineTriggerGitConfigurationPullRequestBranches? = null,
    public val events: List<String>? = null,
    public val filePaths: PipelineTriggerGitConfigurationPullRequestFilePaths? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineTriggerGitConfigurationPullRequest): PipelineTriggerGitConfigurationPullRequest = PipelineTriggerGitConfigurationPullRequest(
            branches = javaType.branches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPullRequestBranches.Companion.toKotlin(args0)
                })
            }).orElse(null),
            events = javaType.events().map({ args0 -> args0 }),
            filePaths = javaType.filePaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPullRequestFilePaths.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
