@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property excludes A list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
 * @property includes A list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
 */
public data class PipelineTriggerGitConfigurationPullRequestBranches(
    public val excludes: List<String>? = null,
    public val includes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineTriggerGitConfigurationPullRequestBranches): PipelineTriggerGitConfigurationPullRequestBranches =
            PipelineTriggerGitConfigurationPullRequestBranches(
                excludes = javaType.excludes().map({ args0 -> args0 }),
                includes = javaType.includes().map({ args0 -> args0 }),
            )
    }
}
