@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property branches The field that specifies to filter on branches for the push trigger configuration. A `branches` block is documented below.
 * @property filePaths The field that specifies to filter on file paths for the push trigger configuration. A `file_paths` block is documented below.
 * @property tags The field that contains the details for the Git tags trigger configuration. A `tags` block is documented below.
 */
public data class PipelineTriggerGitConfigurationPush(
    public val branches: PipelineTriggerGitConfigurationPushBranches? = null,
    public val filePaths: PipelineTriggerGitConfigurationPushFilePaths? = null,
    public val tags: PipelineTriggerGitConfigurationPushTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineTriggerGitConfigurationPush): PipelineTriggerGitConfigurationPush = PipelineTriggerGitConfigurationPush(
            branches = javaType.branches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPushBranches.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filePaths = javaType.filePaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPushFilePaths.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.codepipeline.kotlin.outputs.PipelineTriggerGitConfigurationPushTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
