@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultValue The default value of a pipeline-level variable.
 * @property description The description of a pipeline-level variable.
 * > **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
 * @property name The name of a pipeline-level variable.
 */
public data class PipelineVariable(
    public val defaultValue: String? = null,
    public val description: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.PipelineVariable): PipelineVariable = PipelineVariable(
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
