@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codepipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property jsonPath The [JSON path](https://github.com/json-path/JsonPath) to filter on.
 * @property matchEquals The value to match on (e.g., `refs/heads/{Branch}`). See [AWS docs](https://docs.aws.amazon.com/codepipeline/latest/APIReference/API_WebhookFilterRule.html) for details.
 */
public data class WebhookFilter(
    public val jsonPath: String,
    public val matchEquals: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codepipeline.outputs.WebhookFilter): WebhookFilter = WebhookFilter(
            jsonPath = javaType.jsonPath(),
            matchEquals = javaType.matchEquals(),
        )
    }
}
