@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions.getConnectionPlain
import com.pulumi.aws.codestarconnections.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.codestarconnections.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.codestarconnections.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.codestarconnections.kotlin.outputs.GetConnectionResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object CodestarconnectionsFunctions {
    /**
     * Provides details about CodeStar Connection.
     * ## Example Usage
     * ### By ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.codestarconnections.getConnection({
     *     arn: exampleAwsCodestarconnectionsConnection.arn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.codestarconnections.get_connection(arn=example_aws_codestarconnections_connection["arn"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CodeStarConnections.GetConnection.Invoke(new()
     *     {
     *         Arn = exampleAwsCodestarconnectionsConnection.Arn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarconnections"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codestarconnections.LookupConnection(ctx, &codestarconnections.LookupConnectionArgs{
     * 			Arn: pulumi.StringRef(exampleAwsCodestarconnectionsConnection.Arn),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions;
     * import com.pulumi.aws.codestarconnections.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodestarconnectionsFunctions.getConnection(GetConnectionArgs.builder()
     *             .arn(exampleAwsCodestarconnectionsConnection.arn())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:codestarconnections:getConnection
     *       Arguments:
     *         arn: ${exampleAwsCodestarconnectionsConnection.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.codestarconnections.getConnection({
     *     name: exampleAwsCodestarconnectionsConnection.name,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.codestarconnections.get_connection(name=example_aws_codestarconnections_connection["name"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.CodeStarConnections.GetConnection.Invoke(new()
     *     {
     *         Name = exampleAwsCodestarconnectionsConnection.Name,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarconnections"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := codestarconnections.LookupConnection(ctx, &codestarconnections.LookupConnectionArgs{
     * 			Name: pulumi.StringRef(exampleAwsCodestarconnectionsConnection.Name),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.codestarconnections.CodestarconnectionsFunctions;
     * import com.pulumi.aws.codestarconnections.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CodestarconnectionsFunctions.getConnection(GetConnectionArgs.builder()
     *             .name(exampleAwsCodestarconnectionsConnection.name())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:codestarconnections:getConnection
     *       Arguments:
     *         name: ${exampleAwsCodestarconnectionsConnection.name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        toKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param arn CodeStar Connection ARN.
     * @param name CodeStar Connection name.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @param tags Map of key-value resource tags to associate with the resource.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return toKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;codestarconnections&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit): GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }
}
