@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.aws.codestarconnections.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * Provides a CodeStar Connection.
 * > **NOTE:** The `aws.codestarconnections.Connection` resource is created in the state `PENDING`. Authentication with the connection provider must be completed in the AWS Console. See the [AWS documentation](https://docs.aws.amazon.com/dtconsole/latest/userguide/connections-update.html) for details.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codestarconnections.Connection("example", {
 *     name: "example-connection",
 *     providerType: "Bitbucket",
 * });
 * const examplePipeline = new aws.codepipeline.Pipeline("example", {
 *     artifactStores: [{}],
 *     stages: [
 *         {
 *             name: "Source",
 *             actions: [{
 *                 name: "Source",
 *                 category: "Source",
 *                 owner: "AWS",
 *                 provider: "CodeStarSourceConnection",
 *                 version: "1",
 *                 outputArtifacts: ["source_output"],
 *                 configuration: {
 *                     ConnectionArn: example.arn,
 *                     FullRepositoryId: "my-organization/test",
 *                     BranchName: "main",
 *                 },
 *             }],
 *         },
 *         {
 *             actions: [{}],
 *             name: "Build",
 *         },
 *         {
 *             actions: [{}],
 *             name: "Deploy",
 *         },
 *     ],
 *     name: "tf-test-pipeline",
 *     roleArn: codepipelineRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codestarconnections.Connection("example",
 *     name="example-connection",
 *     provider_type="Bitbucket")
 * example_pipeline = aws.codepipeline.Pipeline("example",
 *     artifact_stores=[{}],
 *     stages=[
 *         {
 *             "name": "Source",
 *             "actions": [{
 *                 "name": "Source",
 *                 "category": "Source",
 *                 "owner": "AWS",
 *                 "provider": "CodeStarSourceConnection",
 *                 "version": "1",
 *                 "output_artifacts": ["source_output"],
 *                 "configuration": {
 *                     "connection_arn": example.arn,
 *                     "full_repository_id": "my-organization/test",
 *                     "branch_name": "main",
 *                 },
 *             }],
 *         },
 *         {
 *             "actions": [{}],
 *             "name": "Build",
 *         },
 *         {
 *             "actions": [{}],
 *             "name": "Deploy",
 *         },
 *     ],
 *     name="tf-test-pipeline",
 *     role_arn=codepipeline_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeStarConnections.Connection("example", new()
 *     {
 *         Name = "example-connection",
 *         ProviderType = "Bitbucket",
 *     });
 *     var examplePipeline = new Aws.CodePipeline.Pipeline("example", new()
 *     {
 *         ArtifactStores = new[]
 *         {
 *             null,
 *         },
 *         Stages = new[]
 *         {
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Name = "Source",
 *                 Actions = new[]
 *                 {
 *                     new Aws.CodePipeline.Inputs.PipelineStageActionArgs
 *                     {
 *                         Name = "Source",
 *                         Category = "Source",
 *                         Owner = "AWS",
 *                         Provider = "CodeStarSourceConnection",
 *                         Version = "1",
 *                         OutputArtifacts = new[]
 *                         {
 *                             "source_output",
 *                         },
 *                         Configuration =
 *                         {
 *                             { "ConnectionArn", example.Arn },
 *                             { "FullRepositoryId", "my-organization/test" },
 *                             { "BranchName", "main" },
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     null,
 *                 },
 *                 Name = "Build",
 *             },
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     null,
 *                 },
 *                 Name = "Deploy",
 *             },
 *         },
 *         Name = "tf-test-pipeline",
 *         RoleArn = codepipelineRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codepipeline"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarconnections"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codestarconnections.NewConnection(ctx, "example", &codestarconnections.ConnectionArgs{
 * 			Name:         pulumi.String("example-connection"),
 * 			ProviderType: pulumi.String("Bitbucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codepipeline.NewPipeline(ctx, "example", &codepipeline.PipelineArgs{
 * 			ArtifactStores: codepipeline.PipelineArtifactStoreArray{
 * 				nil,
 * 			},
 * 			Stages: codepipeline.PipelineStageArray{
 * 				&codepipeline.PipelineStageArgs{
 * 					Name: pulumi.String("Source"),
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						&codepipeline.PipelineStageActionArgs{
 * 							Name:     pulumi.String("Source"),
 * 							Category: pulumi.String("Source"),
 * 							Owner:    pulumi.String("AWS"),
 * 							Provider: pulumi.String("CodeStarSourceConnection"),
 * 							Version:  pulumi.String("1"),
 * 							OutputArtifacts: pulumi.StringArray{
 * 								pulumi.String("source_output"),
 * 							},
 * 							Configuration: pulumi.StringMap{
 * 								"ConnectionArn":    example.Arn,
 * 								"FullRepositoryId": pulumi.String("my-organization/test"),
 * 								"BranchName":       pulumi.String("main"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&codepipeline.PipelineStageArgs{
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						nil,
 * 					},
 * 					Name: pulumi.String("Build"),
 * 				},
 * 				&codepipeline.PipelineStageArgs{
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						nil,
 * 					},
 * 					Name: pulumi.String("Deploy"),
 * 				},
 * 			},
 * 			Name:    pulumi.String("tf-test-pipeline"),
 * 			RoleArn: pulumi.Any(codepipelineRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Connection;
 * import com.pulumi.aws.codestarconnections.ConnectionArgs;
 * import com.pulumi.aws.codepipeline.Pipeline;
 * import com.pulumi.aws.codepipeline.PipelineArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .name("example-connection")
 *             .providerType("Bitbucket")
 *             .build());
 *         var examplePipeline = new Pipeline("examplePipeline", PipelineArgs.builder()
 *             .artifactStores()
 *             .stages(
 *                 PipelineStageArgs.builder()
 *                     .name("Source")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Source")
 *                         .category("Source")
 *                         .owner("AWS")
 *                         .provider("CodeStarSourceConnection")
 *                         .version("1")
 *                         .outputArtifacts("source_output")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ConnectionArn", example.arn()),
 *                             Map.entry("FullRepositoryId", "my-organization/test"),
 *                             Map.entry("BranchName", "main")
 *                         ))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .actions()
 *                     .name("Build")
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .actions()
 *                     .name("Deploy")
 *                     .build())
 *             .name("tf-test-pipeline")
 *             .roleArn(codepipelineRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codestarconnections:Connection
 *     properties:
 *       name: example-connection
 *       providerType: Bitbucket
 *   examplePipeline:
 *     type: aws:codepipeline:Pipeline
 *     name: example
 *     properties:
 *       artifactStores:
 *         - {}
 *       stages:
 *         - name: Source
 *           actions:
 *             - name: Source
 *               category: Source
 *               owner: AWS
 *               provider: CodeStarSourceConnection
 *               version: '1'
 *               outputArtifacts:
 *                 - source_output
 *               configuration:
 *                 ConnectionArn: ${example.arn}
 *                 FullRepositoryId: my-organization/test
 *                 BranchName: main
 *         - actions:
 *             - {}
 *           name: Build
 *         - actions:
 *             - {}
 *           name: Deploy
 *       name: tf-test-pipeline
 *       roleArn: ${codepipelineRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeStar connections using the ARN. For example:
 * ```sh
 * $ pulumi import aws:codestarconnections/connection:Connection test-connection arn:aws:codestar-connections:us-west-1:0123456789:connection/79d4d357-a2ee-41e4-b350-2fe39ae59448
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.aws.codestarconnections.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * The codestar connection ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The codestar connection status. Possible values are `PENDING`, `AVAILABLE` and `ERROR`.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the host associated with the connection. Conflicts with `provider_type`
     */
    public val hostArn: Output<String>?
        get() = javaResource.hostArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the connection to be created. The name must be unique in the calling AWS account. Changing `name` will create a new resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the external provider where your third-party code repository is configured. Valid values are `Bitbucket`, `GitHub`, `GitHubEnterpriseServer`, `GitLab` or `GitLabSelfManaged`. Changing `provider_type` will create a new resource. Conflicts with `host_arn`
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })

    /**
     * Map of key-value resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codestarconnections.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.aws.codestarconnections.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
