@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin

import com.pulumi.aws.codestarconnections.ConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeStar Connection.
 * > **NOTE:** The `aws.codestarconnections.Connection` resource is created in the state `PENDING`. Authentication with the connection provider must be completed in the AWS Console. See the [AWS documentation](https://docs.aws.amazon.com/dtconsole/latest/userguide/connections-update.html) for details.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codestarconnections.Connection("example", {
 *     name: "example-connection",
 *     providerType: "Bitbucket",
 * });
 * const examplePipeline = new aws.codepipeline.Pipeline("example", {
 *     artifactStores: [{}],
 *     stages: [
 *         {
 *             name: "Source",
 *             actions: [{
 *                 name: "Source",
 *                 category: "Source",
 *                 owner: "AWS",
 *                 provider: "CodeStarSourceConnection",
 *                 version: "1",
 *                 outputArtifacts: ["source_output"],
 *                 configuration: {
 *                     ConnectionArn: example.arn,
 *                     FullRepositoryId: "my-organization/test",
 *                     BranchName: "main",
 *                 },
 *             }],
 *         },
 *         {
 *             actions: [{}],
 *             name: "Build",
 *         },
 *         {
 *             actions: [{}],
 *             name: "Deploy",
 *         },
 *     ],
 *     name: "tf-test-pipeline",
 *     roleArn: codepipelineRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codestarconnections.Connection("example",
 *     name="example-connection",
 *     provider_type="Bitbucket")
 * example_pipeline = aws.codepipeline.Pipeline("example",
 *     artifact_stores=[{}],
 *     stages=[
 *         {
 *             "name": "Source",
 *             "actions": [{
 *                 "name": "Source",
 *                 "category": "Source",
 *                 "owner": "AWS",
 *                 "provider": "CodeStarSourceConnection",
 *                 "version": "1",
 *                 "output_artifacts": ["source_output"],
 *                 "configuration": {
 *                     "connection_arn": example.arn,
 *                     "full_repository_id": "my-organization/test",
 *                     "branch_name": "main",
 *                 },
 *             }],
 *         },
 *         {
 *             "actions": [{}],
 *             "name": "Build",
 *         },
 *         {
 *             "actions": [{}],
 *             "name": "Deploy",
 *         },
 *     ],
 *     name="tf-test-pipeline",
 *     role_arn=codepipeline_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeStarConnections.Connection("example", new()
 *     {
 *         Name = "example-connection",
 *         ProviderType = "Bitbucket",
 *     });
 *     var examplePipeline = new Aws.CodePipeline.Pipeline("example", new()
 *     {
 *         ArtifactStores = new[]
 *         {
 *             null,
 *         },
 *         Stages = new[]
 *         {
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Name = "Source",
 *                 Actions = new[]
 *                 {
 *                     new Aws.CodePipeline.Inputs.PipelineStageActionArgs
 *                     {
 *                         Name = "Source",
 *                         Category = "Source",
 *                         Owner = "AWS",
 *                         Provider = "CodeStarSourceConnection",
 *                         Version = "1",
 *                         OutputArtifacts = new[]
 *                         {
 *                             "source_output",
 *                         },
 *                         Configuration =
 *                         {
 *                             { "ConnectionArn", example.Arn },
 *                             { "FullRepositoryId", "my-organization/test" },
 *                             { "BranchName", "main" },
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     null,
 *                 },
 *                 Name = "Build",
 *             },
 *             new Aws.CodePipeline.Inputs.PipelineStageArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     null,
 *                 },
 *                 Name = "Deploy",
 *             },
 *         },
 *         Name = "tf-test-pipeline",
 *         RoleArn = codepipelineRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codepipeline"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarconnections"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := codestarconnections.NewConnection(ctx, "example", &codestarconnections.ConnectionArgs{
 * 			Name:         pulumi.String("example-connection"),
 * 			ProviderType: pulumi.String("Bitbucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codepipeline.NewPipeline(ctx, "example", &codepipeline.PipelineArgs{
 * 			ArtifactStores: codepipeline.PipelineArtifactStoreArray{
 * 				nil,
 * 			},
 * 			Stages: codepipeline.PipelineStageArray{
 * 				&codepipeline.PipelineStageArgs{
 * 					Name: pulumi.String("Source"),
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						&codepipeline.PipelineStageActionArgs{
 * 							Name:     pulumi.String("Source"),
 * 							Category: pulumi.String("Source"),
 * 							Owner:    pulumi.String("AWS"),
 * 							Provider: pulumi.String("CodeStarSourceConnection"),
 * 							Version:  pulumi.String("1"),
 * 							OutputArtifacts: pulumi.StringArray{
 * 								pulumi.String("source_output"),
 * 							},
 * 							Configuration: pulumi.StringMap{
 * 								"ConnectionArn":    example.Arn,
 * 								"FullRepositoryId": pulumi.String("my-organization/test"),
 * 								"BranchName":       pulumi.String("main"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&codepipeline.PipelineStageArgs{
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						nil,
 * 					},
 * 					Name: pulumi.String("Build"),
 * 				},
 * 				&codepipeline.PipelineStageArgs{
 * 					Actions: codepipeline.PipelineStageActionArray{
 * 						nil,
 * 					},
 * 					Name: pulumi.String("Deploy"),
 * 				},
 * 			},
 * 			Name:    pulumi.String("tf-test-pipeline"),
 * 			RoleArn: pulumi.Any(codepipelineRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codestarconnections.Connection;
 * import com.pulumi.aws.codestarconnections.ConnectionArgs;
 * import com.pulumi.aws.codepipeline.Pipeline;
 * import com.pulumi.aws.codepipeline.PipelineArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineArtifactStoreArgs;
 * import com.pulumi.aws.codepipeline.inputs.PipelineStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .name("example-connection")
 *             .providerType("Bitbucket")
 *             .build());
 *         var examplePipeline = new Pipeline("examplePipeline", PipelineArgs.builder()
 *             .artifactStores()
 *             .stages(
 *                 PipelineStageArgs.builder()
 *                     .name("Source")
 *                     .actions(PipelineStageActionArgs.builder()
 *                         .name("Source")
 *                         .category("Source")
 *                         .owner("AWS")
 *                         .provider("CodeStarSourceConnection")
 *                         .version("1")
 *                         .outputArtifacts("source_output")
 *                         .configuration(Map.ofEntries(
 *                             Map.entry("ConnectionArn", example.arn()),
 *                             Map.entry("FullRepositoryId", "my-organization/test"),
 *                             Map.entry("BranchName", "main")
 *                         ))
 *                         .build())
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .actions()
 *                     .name("Build")
 *                     .build(),
 *                 PipelineStageArgs.builder()
 *                     .actions()
 *                     .name("Deploy")
 *                     .build())
 *             .name("tf-test-pipeline")
 *             .roleArn(codepipelineRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codestarconnections:Connection
 *     properties:
 *       name: example-connection
 *       providerType: Bitbucket
 *   examplePipeline:
 *     type: aws:codepipeline:Pipeline
 *     name: example
 *     properties:
 *       artifactStores:
 *         - {}
 *       stages:
 *         - name: Source
 *           actions:
 *             - name: Source
 *               category: Source
 *               owner: AWS
 *               provider: CodeStarSourceConnection
 *               version: '1'
 *               outputArtifacts:
 *                 - source_output
 *               configuration:
 *                 ConnectionArn: ${example.arn}
 *                 FullRepositoryId: my-organization/test
 *                 BranchName: main
 *         - actions:
 *             - {}
 *           name: Build
 *         - actions:
 *             - {}
 *           name: Deploy
 *       name: tf-test-pipeline
 *       roleArn: ${codepipelineRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeStar connections using the ARN. For example:
 * ```sh
 * $ pulumi import aws:codestarconnections/connection:Connection test-connection arn:aws:codestar-connections:us-west-1:0123456789:connection/79d4d357-a2ee-41e4-b350-2fe39ae59448
 * ```
 * @property hostArn The Amazon Resource Name (ARN) of the host associated with the connection. Conflicts with `provider_type`
 * @property name The name of the connection to be created. The name must be unique in the calling AWS account. Changing `name` will create a new resource.
 * @property providerType The name of the external provider where your third-party code repository is configured. Valid values are `Bitbucket`, `GitHub`, `GitHubEnterpriseServer`, `GitLab` or `GitLabSelfManaged`. Changing `provider_type` will create a new resource. Conflicts with `host_arn`
 * @property tags Map of key-value resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val hostArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val providerType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarconnections.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.codestarconnections.ConnectionArgs =
        com.pulumi.aws.codestarconnections.ConnectionArgs.builder()
            .hostArn(hostArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .providerType(providerType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var hostArn: Output<String>? = null

    private var name: Output<String>? = null

    private var providerType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the host associated with the connection. Conflicts with `provider_type`
     */
    @JvmName("xxyjblkselpxyuuy")
    public suspend fun hostArn(`value`: Output<String>) {
        this.hostArn = value
    }

    /**
     * @param value The name of the connection to be created. The name must be unique in the calling AWS account. Changing `name` will create a new resource.
     */
    @JvmName("hlfqfvutcmqtxfxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the external provider where your third-party code repository is configured. Valid values are `Bitbucket`, `GitHub`, `GitHubEnterpriseServer`, `GitLab` or `GitLabSelfManaged`. Changing `provider_type` will create a new resource. Conflicts with `host_arn`
     */
    @JvmName("shcaxkmnjvooyrvr")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Map of key-value resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tiyhkaswwkilucwu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the host associated with the connection. Conflicts with `provider_type`
     */
    @JvmName("owyjuyastcstiqnw")
    public suspend fun hostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostArn = mapped
    }

    /**
     * @param value The name of the connection to be created. The name must be unique in the calling AWS account. Changing `name` will create a new resource.
     */
    @JvmName("sbppjhjuygrkppvj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the external provider where your third-party code repository is configured. Valid values are `Bitbucket`, `GitHub`, `GitHubEnterpriseServer`, `GitLab` or `GitLabSelfManaged`. Changing `provider_type` will create a new resource. Conflicts with `host_arn`
     */
    @JvmName("luhdotfbvqamduvp")
    public suspend fun providerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Map of key-value resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cuudpofhcrmqwwqd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qkvvguqqblujgplm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        hostArn = hostArn,
        name = name,
        providerType = providerType,
        tags = tags,
    )
}
