@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getConnection.
 * @property arn
 * @property connectionStatus CodeStar Connection status. Possible values are `PENDING`, `AVAILABLE` and `ERROR`.
 * @property hostArn ARN of the host associated with the connection.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the CodeStar Connection. The name is unique in the calling AWS account.
 * @property providerType Name of the external provider where your third-party code repository is configured. Possible values are `Bitbucket`, `GitHub` and `GitLab`. For connections to GitHub Enterprise Server or GitLab Self-Managed instances, you must create an aws.codestarconnections.Host resource and use `host_arn` instead.
 * @property tags Map of key-value resource tags to associate with the resource.
 */
public data class GetConnectionResult(
    public val arn: String,
    public val connectionStatus: String,
    public val hostArn: String,
    public val id: String,
    public val name: String,
    public val providerType: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codestarconnections.outputs.GetConnectionResult): GetConnectionResult = GetConnectionResult(
            arn = javaType.arn(),
            connectionStatus = javaType.connectionStatus(),
            hostArn = javaType.hostArn(),
            id = javaType.id(),
            name = javaType.name(),
            providerType = javaType.providerType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
