@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarconnections.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
 * @property subnetIds The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.
 * @property tlsCertificate The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.
 * @property vpcId The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.
 */
public data class HostVpcConfiguration(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val tlsCertificate: String? = null,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codestarconnections.outputs.HostVpcConfiguration): HostVpcConfiguration = HostVpcConfiguration(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tlsCertificate = javaType.tlsCertificate().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId(),
        )
    }
}
