@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin

import com.pulumi.aws.codestarnotifications.kotlin.outputs.NotificationRuleTarget
import com.pulumi.aws.codestarnotifications.kotlin.outputs.NotificationRuleTarget.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NotificationRule].
 */
@PulumiTagMarker
public class NotificationRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationRuleArgs = NotificationRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationRuleArgsBuilder.() -> Unit) {
        val builder = NotificationRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotificationRule {
        val builtJavaResource =
            com.pulumi.aws.codestarnotifications.NotificationRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationRule(builtJavaResource)
    }
}

/**
 * Provides a CodeStar Notifications Rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const code = new aws.codecommit.Repository("code", {repositoryName: "example-code-repo"});
 * const notif = new aws.sns.Topic("notif", {name: "notification"});
 * const notifAccess = notif.arn.apply(arn => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         actions: ["sns:Publish"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codestar-notifications&#46;amazonaws&#46;com"],
 *         }],
 *         resources: [arn],
 *     }],
 * }));
 * const _default = new aws.sns.TopicPolicy("default", {
 *     arn: notif.arn,
 *     policy: notifAccess.apply(notifAccess => notifAccess.json),
 * });
 * const commits = new aws.codestarnotifications.NotificationRule("commits", {
 *     detailType: "BASIC",
 *     eventTypeIds: ["codecommit-repository-comments-on-commits"],
 *     name: "example-code-repo-commits",
 *     resource: code.arn,
 *     targets: [{
 *         address: notif.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * code = aws.codecommit.Repository("code", repository_name="example-code-repo")
 * notif = aws.sns.Topic("notif", name="notification")
 * notif_access = notif.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
 *     "actions": ["sns:Publish"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codestar-notifications&#46;amazonaws&#46;com"],
 *     }],
 *     "resources": [arn],
 * }]))
 * default = aws.sns.TopicPolicy("default",
 *     arn=notif.arn,
 *     policy=notif_access.json)
 * commits = aws.codestarnotifications.NotificationRule("commits",
 *     detail_type="BASIC",
 *     event_type_ids=["codecommit-repository-comments-on-commits"],
 *     name="example-code-repo-commits",
 *     resource=code.arn,
 *     targets=[{
 *         "address": notif.arn,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var code = new Aws.CodeCommit.Repository("code", new()
 *     {
 *         RepositoryName = "example-code-repo",
 *     });
 *     var notif = new Aws.Sns.Topic("notif", new()
 *     {
 *         Name = "notification",
 *     });
 *     var notifAccess = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sns:Publish",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codestar-notifications.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Resources = new[]
 *                 {
 *                     notif.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var @default = new Aws.Sns.TopicPolicy("default", new()
 *     {
 *         Arn = notif.Arn,
 *         Policy = notifAccess.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var commits = new Aws.CodeStarNotifications.NotificationRule("commits", new()
 *     {
 *         DetailType = "BASIC",
 *         EventTypeIds = new[]
 *         {
 *             "codecommit-repository-comments-on-commits",
 *         },
 *         Name = "example-code-repo-commits",
 *         Resource = code.Arn,
 *         Targets = new[]
 *         {
 *             new Aws.CodeStarNotifications.Inputs.NotificationRuleTargetArgs
 *             {
 *                 Address = notif.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarnotifications"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * code, err := codecommit.NewRepository(ctx, "code", &codecommit.RepositoryArgs{
 * RepositoryName: pulumi.String("example-code-repo"),
 * })
 * if err != nil {
 * return err
 * }
 * notif, err := sns.NewTopic(ctx, "notif", &sns.TopicArgs{
 * Name: pulumi.String("notification"),
 * })
 * if err != nil {
 * return err
 * }
 * notifAccess := notif.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "sns:Publish",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "codestar-notifications.amazonaws.com",
 * },
 * },
 * },
 * Resources: interface{}{
 * arn,
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = sns.NewTopicPolicy(ctx, "default", &sns.TopicPolicyArgs{
 * Arn: notif.Arn,
 * Policy: pulumi.String(notifAccess.ApplyT(func(notifAccess iam.GetPolicyDocumentResult) (*string, error) {
 * return &notifAccess.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codestarnotifications.NewNotificationRule(ctx, "commits", &codestarnotifications.NotificationRuleArgs{
 * DetailType: pulumi.String("BASIC"),
 * EventTypeIds: pulumi.StringArray{
 * pulumi.String("codecommit-repository-comments-on-commits"),
 * },
 * Name: pulumi.String("example-code-repo-commits"),
 * Resource: code.Arn,
 * Targets: codestarnotifications.NotificationRuleTargetArray{
 * &codestarnotifications.NotificationRuleTargetArgs{
 * Address: notif.Arn,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.codestarnotifications.NotificationRule;
 * import com.pulumi.aws.codestarnotifications.NotificationRuleArgs;
 * import com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var code = new Repository("code", RepositoryArgs.builder()
 *             .repositoryName("example-code-repo")
 *             .build());
 *         var notif = new Topic("notif", TopicArgs.builder()
 *             .name("notification")
 *             .build());
 *         final var notifAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sns:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codestar-notifications.amazonaws.com")
 *                     .build())
 *                 .resources(notif.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(notif.arn())
 *             .policy(notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(notifAccess -> notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var commits = new NotificationRule("commits", NotificationRuleArgs.builder()
 *             .detailType("BASIC")
 *             .eventTypeIds("codecommit-repository-comments-on-commits")
 *             .name("example-code-repo-commits")
 *             .resource(code.arn())
 *             .targets(NotificationRuleTargetArgs.builder()
 *                 .address(notif.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   code:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: example-code-repo
 *   notif:
 *     type: aws:sns:Topic
 *     properties:
 *       name: notification
 *   default:
 *     type: aws:sns:TopicPolicy
 *     properties:
 *       arn: ${notif.arn}
 *       policy: ${notifAccess.json}
 *   commits:
 *     type: aws:codestarnotifications:NotificationRule
 *     properties:
 *       detailType: BASIC
 *       eventTypeIds:
 *         - codecommit-repository-comments-on-commits
 *       name: example-code-repo-commits
 *       resource: ${code.arn}
 *       targets:
 *         - address: ${notif.arn}
 * variables:
 *   notifAccess:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sns:Publish
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codestar-notifications.amazonaws.com
 *             resources:
 *               - ${notif.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeStar notification rule using the ARN. For example:
 * ```sh
 * $ pulumi import aws:codestarnotifications/notificationRule:NotificationRule foo arn:aws:codestar-notifications:us-west-1:0123456789:notificationrule/2cdc68a3-8f7c-4893-b6a5-45b362bd4f2b
 * ```
 */
public class NotificationRule internal constructor(
    override val javaResource: com.pulumi.aws.codestarnotifications.NotificationRule,
) : KotlinCustomResource(javaResource, NotificationRuleMapper) {
    /**
     * The codestar notification rule ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    public val detailType: Output<String>
        get() = javaResource.detailType().applyValue({ args0 -> args0 })

    /**
     * A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    public val eventTypeIds: Output<List<String>>
        get() = javaResource.eventTypeIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of notification rule.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource to associate with the notification rule.
     */
    public val resource: Output<String>
        get() = javaResource.resource().applyValue({ args0 -> args0 })

    /**
     * The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    public val targets: Output<List<NotificationRuleTarget>>?
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object NotificationRuleMapper : ResourceMapper<NotificationRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codestarnotifications.NotificationRule::class == javaResource::class

    override fun map(javaResource: Resource): NotificationRule = NotificationRule(
        javaResource as
            com.pulumi.aws.codestarnotifications.NotificationRule,
    )
}

/**
 * @see [NotificationRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationRule].
 */
public suspend fun notificationRule(
    name: String,
    block: suspend NotificationRuleResourceBuilder.() -> Unit,
): NotificationRule {
    val builder = NotificationRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationRule(name: String): NotificationRule {
    val builder = NotificationRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
