@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin

import com.pulumi.aws.codestarnotifications.NotificationRuleArgs.builder
import com.pulumi.aws.codestarnotifications.kotlin.inputs.NotificationRuleTargetArgs
import com.pulumi.aws.codestarnotifications.kotlin.inputs.NotificationRuleTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeStar Notifications Rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const code = new aws.codecommit.Repository("code", {repositoryName: "example-code-repo"});
 * const notif = new aws.sns.Topic("notif", {name: "notification"});
 * const notifAccess = notif.arn.apply(arn => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         actions: ["sns:Publish"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codestar-notifications&#46;amazonaws&#46;com"],
 *         }],
 *         resources: [arn],
 *     }],
 * }));
 * const _default = new aws.sns.TopicPolicy("default", {
 *     arn: notif.arn,
 *     policy: notifAccess.apply(notifAccess => notifAccess.json),
 * });
 * const commits = new aws.codestarnotifications.NotificationRule("commits", {
 *     detailType: "BASIC",
 *     eventTypeIds: ["codecommit-repository-comments-on-commits"],
 *     name: "example-code-repo-commits",
 *     resource: code.arn,
 *     targets: [{
 *         address: notif.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * code = aws.codecommit.Repository("code", repository_name="example-code-repo")
 * notif = aws.sns.Topic("notif", name="notification")
 * notif_access = notif.arn.apply(lambda arn: aws.iam.get_policy_document_output(statements=[{
 *     "actions": ["sns:Publish"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codestar-notifications&#46;amazonaws&#46;com"],
 *     }],
 *     "resources": [arn],
 * }]))
 * default = aws.sns.TopicPolicy("default",
 *     arn=notif.arn,
 *     policy=notif_access.json)
 * commits = aws.codestarnotifications.NotificationRule("commits",
 *     detail_type="BASIC",
 *     event_type_ids=["codecommit-repository-comments-on-commits"],
 *     name="example-code-repo-commits",
 *     resource=code.arn,
 *     targets=[{
 *         "address": notif.arn,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var code = new Aws.CodeCommit.Repository("code", new()
 *     {
 *         RepositoryName = "example-code-repo",
 *     });
 *     var notif = new Aws.Sns.Topic("notif", new()
 *     {
 *         Name = "notification",
 *     });
 *     var notifAccess = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sns:Publish",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codestar-notifications.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Resources = new[]
 *                 {
 *                     notif.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var @default = new Aws.Sns.TopicPolicy("default", new()
 *     {
 *         Arn = notif.Arn,
 *         Policy = notifAccess.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var commits = new Aws.CodeStarNotifications.NotificationRule("commits", new()
 *     {
 *         DetailType = "BASIC",
 *         EventTypeIds = new[]
 *         {
 *             "codecommit-repository-comments-on-commits",
 *         },
 *         Name = "example-code-repo-commits",
 *         Resource = code.Arn,
 *         Targets = new[]
 *         {
 *             new Aws.CodeStarNotifications.Inputs.NotificationRuleTargetArgs
 *             {
 *                 Address = notif.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codecommit"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codestarnotifications"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * code, err := codecommit.NewRepository(ctx, "code", &codecommit.RepositoryArgs{
 * RepositoryName: pulumi.String("example-code-repo"),
 * })
 * if err != nil {
 * return err
 * }
 * notif, err := sns.NewTopic(ctx, "notif", &sns.TopicArgs{
 * Name: pulumi.String("notification"),
 * })
 * if err != nil {
 * return err
 * }
 * notifAccess := notif.Arn.ApplyT(func(arn string) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Actions: []string{
 * "sns:Publish",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "codestar-notifications.amazonaws.com",
 * },
 * },
 * },
 * Resources: interface{}{
 * arn,
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = sns.NewTopicPolicy(ctx, "default", &sns.TopicPolicyArgs{
 * Arn: notif.Arn,
 * Policy: pulumi.String(notifAccess.ApplyT(func(notifAccess iam.GetPolicyDocumentResult) (*string, error) {
 * return &notifAccess.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codestarnotifications.NewNotificationRule(ctx, "commits", &codestarnotifications.NotificationRuleArgs{
 * DetailType: pulumi.String("BASIC"),
 * EventTypeIds: pulumi.StringArray{
 * pulumi.String("codecommit-repository-comments-on-commits"),
 * },
 * Name: pulumi.String("example-code-repo-commits"),
 * Resource: code.Arn,
 * Targets: codestarnotifications.NotificationRuleTargetArray{
 * &codestarnotifications.NotificationRuleTargetArgs{
 * Address: notif.Arn,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecommit.Repository;
 * import com.pulumi.aws.codecommit.RepositoryArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.codestarnotifications.NotificationRule;
 * import com.pulumi.aws.codestarnotifications.NotificationRuleArgs;
 * import com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var code = new Repository("code", RepositoryArgs.builder()
 *             .repositoryName("example-code-repo")
 *             .build());
 *         var notif = new Topic("notif", TopicArgs.builder()
 *             .name("notification")
 *             .build());
 *         final var notifAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sns:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codestar-notifications.amazonaws.com")
 *                     .build())
 *                 .resources(notif.arn())
 *                 .build())
 *             .build());
 *         var default_ = new TopicPolicy("default", TopicPolicyArgs.builder()
 *             .arn(notif.arn())
 *             .policy(notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(notifAccess -> notifAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var commits = new NotificationRule("commits", NotificationRuleArgs.builder()
 *             .detailType("BASIC")
 *             .eventTypeIds("codecommit-repository-comments-on-commits")
 *             .name("example-code-repo-commits")
 *             .resource(code.arn())
 *             .targets(NotificationRuleTargetArgs.builder()
 *                 .address(notif.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   code:
 *     type: aws:codecommit:Repository
 *     properties:
 *       repositoryName: example-code-repo
 *   notif:
 *     type: aws:sns:Topic
 *     properties:
 *       name: notification
 *   default:
 *     type: aws:sns:TopicPolicy
 *     properties:
 *       arn: ${notif.arn}
 *       policy: ${notifAccess.json}
 *   commits:
 *     type: aws:codestarnotifications:NotificationRule
 *     properties:
 *       detailType: BASIC
 *       eventTypeIds:
 *         - codecommit-repository-comments-on-commits
 *       name: example-code-repo-commits
 *       resource: ${code.arn}
 *       targets:
 *         - address: ${notif.arn}
 * variables:
 *   notifAccess:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sns:Publish
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codestar-notifications.amazonaws.com
 *             resources:
 *               - ${notif.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeStar notification rule using the ARN. For example:
 * ```sh
 * $ pulumi import aws:codestarnotifications/notificationRule:NotificationRule foo arn:aws:codestar-notifications:us-west-1:0123456789:notificationrule/2cdc68a3-8f7c-4893-b6a5-45b362bd4f2b
 * ```
 * @property detailType The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
 * @property eventTypeIds A list of event types associated with this notification rule.
 * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
 * @property name The name of notification rule.
 * @property resource The ARN of the resource to associate with the notification rule.
 * @property status The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targets Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
 */
public data class NotificationRuleArgs(
    public val detailType: Output<String>? = null,
    public val eventTypeIds: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val resource: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<NotificationRuleTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarnotifications.NotificationRuleArgs> {
    override fun toJava(): com.pulumi.aws.codestarnotifications.NotificationRuleArgs =
        com.pulumi.aws.codestarnotifications.NotificationRuleArgs.builder()
            .detailType(detailType?.applyValue({ args0 -> args0 }))
            .eventTypeIds(eventTypeIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resource(resource?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationRuleArgs].
 */
@PulumiTagMarker
public class NotificationRuleArgsBuilder internal constructor() {
    private var detailType: Output<String>? = null

    private var eventTypeIds: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var resource: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<NotificationRuleTargetArgs>>? = null

    /**
     * @param value The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    @JvmName("xpdissivkuhbofcf")
    public suspend fun detailType(`value`: Output<String>) {
        this.detailType = value
    }

    /**
     * @param value A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("ncaapuojqlocgimc")
    public suspend fun eventTypeIds(`value`: Output<List<String>>) {
        this.eventTypeIds = value
    }

    @JvmName("tnxtvewdmmykghfn")
    public suspend fun eventTypeIds(vararg values: Output<String>) {
        this.eventTypeIds = Output.all(values.asList())
    }

    /**
     * @param values A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("rgkdlcrvcxthmspv")
    public suspend fun eventTypeIds(values: List<Output<String>>) {
        this.eventTypeIds = Output.all(values)
    }

    /**
     * @param value The name of notification rule.
     */
    @JvmName("sxhlhdgakrgoewfv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the resource to associate with the notification rule.
     */
    @JvmName("alpiqvkqngsnfnce")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("btubrlhvvqaduvap")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oqkgphfmoakedqnj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("diemppfhlmrrxpve")
    public suspend fun targets(`value`: Output<List<NotificationRuleTargetArgs>>) {
        this.targets = value
    }

    @JvmName("nrohkdssglxivhre")
    public suspend fun targets(vararg values: Output<NotificationRuleTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("yihyoqyndyvwvful")
    public suspend fun targets(values: List<Output<NotificationRuleTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The level of detail to include in the notifications for this resource. Possible values are `BASIC` and `FULL`.
     */
    @JvmName("eexevjfblphxxxrb")
    public suspend fun detailType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailType = mapped
    }

    /**
     * @param value A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("euxsapebwaitbwkm")
    public suspend fun eventTypeIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTypeIds = mapped
    }

    /**
     * @param values A list of event types associated with this notification rule.
     * For list of allowed events see [here](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api).
     */
    @JvmName("ndlldsohxtlukbnf")
    public suspend fun eventTypeIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventTypeIds = mapped
    }

    /**
     * @param value The name of notification rule.
     */
    @JvmName("yjibdclmrrsipidj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the resource to associate with the notification rule.
     */
    @JvmName("cvjmlibrsoicryiq")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("amxrmphigvrvcolt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("khaxbrdtlgboiyml")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uuwocmrlshqnprcp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("opviwdqhwarkqenx")
    public suspend fun targets(`value`: List<NotificationRuleTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("pejqcvrergjrwrda")
    public suspend fun targets(argument: List<suspend NotificationRuleTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("yhxlpniaqkoqmsmr")
    public suspend fun targets(vararg argument: suspend NotificationRuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NotificationRuleTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("xxrhhadbtxftpifu")
    public suspend fun targets(argument: suspend NotificationRuleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NotificationRuleTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values Configuration blocks containing notification target information. Can be specified multiple times. At least one target must be specified on creation.
     */
    @JvmName("pawkmglxsocjligf")
    public suspend fun targets(vararg values: NotificationRuleTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): NotificationRuleArgs = NotificationRuleArgs(
        detailType = detailType,
        eventTypeIds = eventTypeIds,
        name = name,
        resource = resource,
        status = status,
        tags = tags,
        targets = targets,
    )
}
