@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin.inputs

import com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The ARN of notification rule target. For example, a SNS Topic ARN.
 * @property status The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
 * @property type The type of the notification target. Default value is `SNS`.
 */
public data class NotificationRuleTargetArgs(
    public val address: Output<String>,
    public val status: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs> {
    override fun toJava(): com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs =
        com.pulumi.aws.codestarnotifications.inputs.NotificationRuleTargetArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationRuleTargetArgs].
 */
@PulumiTagMarker
public class NotificationRuleTargetArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var status: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ARN of notification rule target. For example, a SNS Topic ARN.
     */
    @JvmName("cenrgyuckqivsmml")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("mnrcpingpkrviqwo")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The type of the notification target. Default value is `SNS`.
     */
    @JvmName("ouevoxlmhyceliwl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ARN of notification rule target. For example, a SNS Topic ARN.
     */
    @JvmName("celxoqrtvqbpwulr")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
     */
    @JvmName("jvqxhwwawlnooanf")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The type of the notification target. Default value is `SNS`.
     */
    @JvmName("nmqtinfevxcxbjvh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): NotificationRuleTargetArgs = NotificationRuleTargetArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        status = status,
        type = type,
    )
}
