@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codestarnotifications.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The ARN of notification rule target. For example, a SNS Topic ARN.
 * @property status The status of the notification rule. Possible values are `ENABLED` and `DISABLED`, default is `ENABLED`.
 * @property type The type of the notification target. Default value is `SNS`.
 */
public data class NotificationRuleTarget(
    public val address: String,
    public val status: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codestarnotifications.outputs.NotificationRuleTarget): NotificationRuleTarget = NotificationRuleTarget(
            address = javaType.address(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
