@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.CognitoFunctions.getIdentityPoolPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserGroupPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserGroupsPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolClientPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolClientsPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolPlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolSigningCertificatePlain
import com.pulumi.aws.cognito.CognitoFunctions.getUserPoolsPlain
import com.pulumi.aws.cognito.kotlin.inputs.GetIdentityPoolPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetIdentityPoolPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserGroupPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserGroupPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserGroupsPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserGroupsPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientsPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolClientsPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolSigningCertificatePlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolSigningCertificatePlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolsPlainArgs
import com.pulumi.aws.cognito.kotlin.inputs.GetUserPoolsPlainArgsBuilder
import com.pulumi.aws.cognito.kotlin.outputs.GetIdentityPoolResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserGroupResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserGroupsResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientsResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSigningCertificateResult
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.cognito.kotlin.outputs.GetIdentityPoolResult.Companion.toKotlin as getIdentityPoolResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserGroupResult.Companion.toKotlin as getUserGroupResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserGroupsResult.Companion.toKotlin as getUserGroupsResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientResult.Companion.toKotlin as getUserPoolClientResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolClientsResult.Companion.toKotlin as getUserPoolClientsResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolResult.Companion.toKotlin as getUserPoolResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolSigningCertificateResult.Companion.toKotlin as getUserPoolSigningCertificateResultToKotlin
import com.pulumi.aws.cognito.kotlin.outputs.GetUserPoolsResult.Companion.toKotlin as getUserPoolsResultToKotlin

public object CognitoFunctions {
    /**
     * Data source for managing an AWS Cognito Identity Pool.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cognito.getIdentityPool({
     *     identityPoolName: "test pool",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cognito.get_identity_pool(identity_pool_name="test pool")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Cognito.GetIdentityPool.Invoke(new()
     *     {
     *         IdentityPoolName = "test pool",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.LookupIdentityPool(ctx, &cognito.LookupIdentityPoolArgs{
     * 			IdentityPoolName: "test pool",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetIdentityPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CognitoFunctions.getIdentityPool(GetIdentityPoolArgs.builder()
     *             .identityPoolName("test pool")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cognito:getIdentityPool
     *       Arguments:
     *         identityPoolName: test pool
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIdentityPool.
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(argument: GetIdentityPoolPlainArgs): GetIdentityPoolResult =
        getIdentityPoolResultToKotlin(getIdentityPoolPlain(argument.toJava()).await())

    /**
     * @see [getIdentityPool].
     * @param identityPoolName The Cognito Identity Pool name.
     * @param tags A map of tags to assigned to the Identity Pool.
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(identityPoolName: String, tags: Map<String, String>? = null): GetIdentityPoolResult {
        val argument = GetIdentityPoolPlainArgs(
            identityPoolName = identityPoolName,
            tags = tags,
        )
        return getIdentityPoolResultToKotlin(getIdentityPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getIdentityPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetIdentityPoolPlainArgs].
     * @return A collection of values returned by getIdentityPool.
     */
    public suspend fun getIdentityPool(argument: suspend GetIdentityPoolPlainArgsBuilder.() -> Unit): GetIdentityPoolResult {
        val builder = GetIdentityPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIdentityPoolResultToKotlin(getIdentityPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Cognito IDP (Identity Provider) User Group.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cognito.getUserGroup({
     *     userPoolId: "us-west-2_aaaaaaaaa",
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cognito.get_user_group(user_pool_id="us-west-2_aaaaaaaaa",
     *     name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Cognito.GetUserGroup.Invoke(new()
     *     {
     *         UserPoolId = "us-west-2_aaaaaaaaa",
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.LookupUserGroup(ctx, &cognito.LookupUserGroupArgs{
     * 			UserPoolId: "us-west-2_aaaaaaaaa",
     * 			Name:       "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CognitoFunctions.getUserGroup(GetUserGroupArgs.builder()
     *             .userPoolId("us-west-2_aaaaaaaaa")
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cognito:getUserGroup
     *       Arguments:
     *         userPoolId: us-west-2_aaaaaaaaa
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserGroup.
     * @return A collection of values returned by getUserGroup.
     */
    public suspend fun getUserGroup(argument: GetUserGroupPlainArgs): GetUserGroupResult =
        getUserGroupResultToKotlin(getUserGroupPlain(argument.toJava()).await())

    /**
     * @see [getUserGroup].
     * @param name Name of the user group.
     * @param userPoolId User pool the client belongs to.
     * @return A collection of values returned by getUserGroup.
     */
    public suspend fun getUserGroup(name: String, userPoolId: String): GetUserGroupResult {
        val argument = GetUserGroupPlainArgs(
            name = name,
            userPoolId = userPoolId,
        )
        return getUserGroupResultToKotlin(getUserGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserGroupPlainArgs].
     * @return A collection of values returned by getUserGroup.
     */
    public suspend fun getUserGroup(argument: suspend GetUserGroupPlainArgsBuilder.() -> Unit): GetUserGroupResult {
        val builder = GetUserGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserGroupResultToKotlin(getUserGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS Cognito IDP (Identity Provider) User Groups.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cognito.getUserGroups({
     *     userPoolId: "us-west-2_aaaaaaaaa",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cognito.get_user_groups(user_pool_id="us-west-2_aaaaaaaaa")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Cognito.GetUserGroups.Invoke(new()
     *     {
     *         UserPoolId = "us-west-2_aaaaaaaaa",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.GetUserGroups(ctx, &cognito.GetUserGroupsArgs{
     * 			UserPoolId: "us-west-2_aaaaaaaaa",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CognitoFunctions.getUserGroups(GetUserGroupsArgs.builder()
     *             .userPoolId("us-west-2_aaaaaaaaa")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cognito:getUserGroups
     *       Arguments:
     *         userPoolId: us-west-2_aaaaaaaaa
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserGroups.
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(argument: GetUserGroupsPlainArgs): GetUserGroupsResult =
        getUserGroupsResultToKotlin(getUserGroupsPlain(argument.toJava()).await())

    /**
     * @see [getUserGroups].
     * @param userPoolId User pool the client belongs to.
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(userPoolId: String): GetUserGroupsResult {
        val argument = GetUserGroupsPlainArgs(
            userPoolId = userPoolId,
        )
        return getUserGroupsResultToKotlin(getUserGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserGroupsPlainArgs].
     * @return A collection of values returned by getUserGroups.
     */
    public suspend fun getUserGroups(argument: suspend GetUserGroupsPlainArgsBuilder.() -> Unit): GetUserGroupsResult {
        val builder = GetUserGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserGroupsResultToKotlin(getUserGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Cognito User Pool.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.cognito.getUserPool({
     *     userPoolId: "us-west-2_aaaaaaaaa",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.cognito.get_user_pool(user_pool_id="us-west-2_aaaaaaaaa")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Cognito.GetUserPool.Invoke(new()
     *     {
     *         UserPoolId = "us-west-2_aaaaaaaaa",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.LookupUserPool(ctx, &cognito.LookupUserPoolArgs{
     * 			UserPoolId: "us-west-2_aaaaaaaaa",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CognitoFunctions.getUserPool(GetUserPoolArgs.builder()
     *             .userPoolId("us-west-2_aaaaaaaaa")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:cognito:getUserPool
     *       Arguments:
     *         userPoolId: us-west-2_aaaaaaaaa
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserPool.
     * @return A collection of values returned by getUserPool.
     */
    public suspend fun getUserPool(argument: GetUserPoolPlainArgs): GetUserPoolResult =
        getUserPoolResultToKotlin(getUserPoolPlain(argument.toJava()).await())

    /**
     * @see [getUserPool].
     * @param userPoolId The cognito pool ID
     * @return A collection of values returned by getUserPool.
     */
    public suspend fun getUserPool(userPoolId: String): GetUserPoolResult {
        val argument = GetUserPoolPlainArgs(
            userPoolId = userPoolId,
        )
        return getUserPoolResultToKotlin(getUserPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolPlainArgs].
     * @return A collection of values returned by getUserPool.
     */
    public suspend fun getUserPool(argument: suspend GetUserPoolPlainArgsBuilder.() -> Unit): GetUserPoolResult {
        val builder = GetUserPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolResultToKotlin(getUserPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a Cognito User Pool Client resource.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const client = aws.cognito.getUserPoolClient({
     *     clientId: "38fjsnc484p94kpqsnet7mpld0",
     *     userPoolId: "us-west-2_aaaaaaaaa",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * client = aws.cognito.get_user_pool_client(client_id="38fjsnc484p94kpqsnet7mpld0",
     *     user_pool_id="us-west-2_aaaaaaaaa")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var client = Aws.Cognito.GetUserPoolClient.Invoke(new()
     *     {
     *         ClientId = "38fjsnc484p94kpqsnet7mpld0",
     *         UserPoolId = "us-west-2_aaaaaaaaa",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.LookupUserPoolClient(ctx, &cognito.LookupUserPoolClientArgs{
     * 			ClientId:   "38fjsnc484p94kpqsnet7mpld0",
     * 			UserPoolId: "us-west-2_aaaaaaaaa",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolClientArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var client = CognitoFunctions.getUserPoolClient(GetUserPoolClientArgs.builder()
     *             .clientId("38fjsnc484p94kpqsnet7mpld0")
     *             .userPoolId("us-west-2_aaaaaaaaa")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   client:
     *     fn::invoke:
     *       Function: aws:cognito:getUserPoolClient
     *       Arguments:
     *         clientId: 38fjsnc484p94kpqsnet7mpld0
     *         userPoolId: us-west-2_aaaaaaaaa
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserPoolClient.
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend fun getUserPoolClient(argument: GetUserPoolClientPlainArgs): GetUserPoolClientResult =
        getUserPoolClientResultToKotlin(getUserPoolClientPlain(argument.toJava()).await())

    /**
     * @see [getUserPoolClient].
     * @param clientId Client Id of the user pool.
     * @param userPoolId User pool the client belongs to.
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend fun getUserPoolClient(clientId: String, userPoolId: String): GetUserPoolClientResult {
        val argument = GetUserPoolClientPlainArgs(
            clientId = clientId,
            userPoolId = userPoolId,
        )
        return getUserPoolClientResultToKotlin(getUserPoolClientPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolClient].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolClientPlainArgs].
     * @return A collection of values returned by getUserPoolClient.
     */
    public suspend fun getUserPoolClient(argument: suspend GetUserPoolClientPlainArgsBuilder.() -> Unit): GetUserPoolClientResult {
        val builder = GetUserPoolClientPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolClientResultToKotlin(getUserPoolClientPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of Cognito user pools clients for a Cognito IdP user pool.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.cognito.getUserPoolClients({
     *     userPoolId: mainAwsCognitoUserPool.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.cognito.get_user_pool_clients(user_pool_id=main_aws_cognito_user_pool["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.Cognito.GetUserPoolClients.Invoke(new()
     *     {
     *         UserPoolId = mainAwsCognitoUserPool.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.GetUserPoolClients(ctx, &cognito.GetUserPoolClientsArgs{
     * 			UserPoolId: mainAwsCognitoUserPool.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolClientsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = CognitoFunctions.getUserPoolClients(GetUserPoolClientsArgs.builder()
     *             .userPoolId(mainAwsCognitoUserPool.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:cognito:getUserPoolClients
     *       Arguments:
     *         userPoolId: ${mainAwsCognitoUserPool.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserPoolClients.
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend fun getUserPoolClients(argument: GetUserPoolClientsPlainArgs): GetUserPoolClientsResult =
        getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(argument.toJava()).await())

    /**
     * @see [getUserPoolClients].
     * @param userPoolId Cognito user pool ID.
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend fun getUserPoolClients(userPoolId: String): GetUserPoolClientsResult {
        val argument = GetUserPoolClientsPlainArgs(
            userPoolId = userPoolId,
        )
        return getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolClients].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolClientsPlainArgs].
     * @return A collection of values returned by getUserPoolClients.
     */
    public suspend fun getUserPoolClients(argument: suspend GetUserPoolClientsPlainArgsBuilder.() -> Unit): GetUserPoolClientsResult {
        val builder = GetUserPoolClientsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolClientsResultToKotlin(getUserPoolClientsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the signing certificate for a Cognito IdP user pool.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const sc = aws.cognito.getUserPoolSigningCertificate({
     *     userPoolId: myPool.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * sc = aws.cognito.get_user_pool_signing_certificate(user_pool_id=my_pool["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sc = Aws.Cognito.GetUserPoolSigningCertificate.Invoke(new()
     *     {
     *         UserPoolId = myPool.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cognito.GetUserPoolSigningCertificate(ctx, &cognito.GetUserPoolSigningCertificateArgs{
     * 			UserPoolId: myPool.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolSigningCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sc = CognitoFunctions.getUserPoolSigningCertificate(GetUserPoolSigningCertificateArgs.builder()
     *             .userPoolId(myPool.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sc:
     *     fn::invoke:
     *       Function: aws:cognito:getUserPoolSigningCertificate
     *       Arguments:
     *         userPoolId: ${myPool.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserPoolSigningCertificate.
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend fun getUserPoolSigningCertificate(argument: GetUserPoolSigningCertificatePlainArgs): GetUserPoolSigningCertificateResult =
        getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(argument.toJava()).await())

    /**
     * @see [getUserPoolSigningCertificate].
     * @param userPoolId Cognito user pool ID.
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend fun getUserPoolSigningCertificate(userPoolId: String): GetUserPoolSigningCertificateResult {
        val argument = GetUserPoolSigningCertificatePlainArgs(
            userPoolId = userPoolId,
        )
        return getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPoolSigningCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolSigningCertificatePlainArgs].
     * @return A collection of values returned by getUserPoolSigningCertificate.
     */
    public suspend fun getUserPoolSigningCertificate(argument: suspend GetUserPoolSigningCertificatePlainArgsBuilder.() -> Unit): GetUserPoolSigningCertificateResult {
        val builder = GetUserPoolSigningCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolSigningCertificateResultToKotlin(getUserPoolSigningCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of cognito user pools.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.apigateway.getRestApi({
     *     name: apiGatewayName,
     * });
     * const selectedGetUserPools = aws.cognito.getUserPools({
     *     name: cognitoUserPoolName,
     * });
     * const cognito = new aws.apigateway.Authorizer("cognito", {
     *     name: "cognito",
     *     type: "COGNITO_USER_POOLS",
     *     restApi: selected.then(selected => selected.id),
     *     providerArns: selectedGetUserPools.then(selectedGetUserPools => selectedGetUserPools.arns),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.apigateway.get_rest_api(name=api_gateway_name)
     * selected_get_user_pools = aws.cognito.get_user_pools(name=cognito_user_pool_name)
     * cognito = aws.apigateway.Authorizer("cognito",
     *     name="cognito",
     *     type="COGNITO_USER_POOLS",
     *     rest_api=selected.id,
     *     provider_arns=selected_get_user_pools.arns)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.ApiGateway.GetRestApi.Invoke(new()
     *     {
     *         Name = apiGatewayName,
     *     });
     *     var selectedGetUserPools = Aws.Cognito.GetUserPools.Invoke(new()
     *     {
     *         Name = cognitoUserPoolName,
     *     });
     *     var cognito = new Aws.ApiGateway.Authorizer("cognito", new()
     *     {
     *         Name = "cognito",
     *         Type = "COGNITO_USER_POOLS",
     *         RestApi = selected.Apply(getRestApiResult => getRestApiResult.Id),
     *         ProviderArns = selectedGetUserPools.Apply(getUserPoolsResult => getUserPoolsResult.Arns),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		selected, err := apigateway.LookupRestApi(ctx, &apigateway.LookupRestApiArgs{
     * 			Name: apiGatewayName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		selectedGetUserPools, err := cognito.GetUserPools(ctx, &cognito.GetUserPoolsArgs{
     * 			Name: cognitoUserPoolName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = apigateway.NewAuthorizer(ctx, "cognito", &apigateway.AuthorizerArgs{
     * 			Name:         pulumi.String("cognito"),
     * 			Type:         pulumi.String("COGNITO_USER_POOLS"),
     * 			RestApi:      pulumi.String(selected.Id),
     * 			ProviderArns: interface{}(selectedGetUserPools.Arns),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetRestApiArgs;
     * import com.pulumi.aws.cognito.CognitoFunctions;
     * import com.pulumi.aws.cognito.inputs.GetUserPoolsArgs;
     * import com.pulumi.aws.apigateway.Authorizer;
     * import com.pulumi.aws.apigateway.AuthorizerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = ApigatewayFunctions.getRestApi(GetRestApiArgs.builder()
     *             .name(apiGatewayName)
     *             .build());
     *         final var selectedGetUserPools = CognitoFunctions.getUserPools(GetUserPoolsArgs.builder()
     *             .name(cognitoUserPoolName)
     *             .build());
     *         var cognito = new Authorizer("cognito", AuthorizerArgs.builder()
     *             .name("cognito")
     *             .type("COGNITO_USER_POOLS")
     *             .restApi(selected.applyValue(getRestApiResult -> getRestApiResult.id()))
     *             .providerArns(selectedGetUserPools.applyValue(getUserPoolsResult -> getUserPoolsResult.arns()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   cognito:
     *     type: aws:apigateway:Authorizer
     *     properties:
     *       name: cognito
     *       type: COGNITO_USER_POOLS
     *       restApi: ${selected.id}
     *       providerArns: ${selectedGetUserPools.arns}
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:apigateway:getRestApi
     *       Arguments:
     *         name: ${apiGatewayName}
     *   selectedGetUserPools:
     *     fn::invoke:
     *       Function: aws:cognito:getUserPools
     *       Arguments:
     *         name: ${cognitoUserPoolName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserPools.
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(argument: GetUserPoolsPlainArgs): GetUserPoolsResult =
        getUserPoolsResultToKotlin(getUserPoolsPlain(argument.toJava()).await())

    /**
     * @see [getUserPools].
     * @param name Name of the cognito user pools. Name is not a unique attribute for cognito user pool, so multiple pools might be returned with given name. If the pool name is expected to be unique, you can reference the pool id via ```tolist(data.aws_cognito_user_pools.selected.ids)[0]```
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(name: String): GetUserPoolsResult {
        val argument = GetUserPoolsPlainArgs(
            name = name,
        )
        return getUserPoolsResultToKotlin(getUserPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;cognito&#46;kotlin&#46;inputs&#46;GetUserPoolsPlainArgs].
     * @return A collection of values returned by getUserPools.
     */
    public suspend fun getUserPools(argument: suspend GetUserPoolsPlainArgsBuilder.() -> Unit): GetUserPoolsResult {
        val builder = GetUserPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserPoolsResultToKotlin(getUserPoolsPlain(builtArgument.toJava()).await())
    }
}
