@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.IdentityPoolCognitoIdentityProvider
import com.pulumi.aws.cognito.kotlin.outputs.IdentityPoolCognitoIdentityProvider.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IdentityPool].
 */
@PulumiTagMarker
public class IdentityPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityPoolArgs = IdentityPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityPoolArgsBuilder.() -> Unit) {
        val builder = IdentityPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IdentityPool {
        val builtJavaResource = com.pulumi.aws.cognito.IdentityPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IdentityPool(builtJavaResource)
    }
}

/**
 * Provides an AWS Cognito Identity Pool.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const _default = new aws.iam.SamlProvider("default", {
 *     name: "my-saml-provider",
 *     samlMetadataDocument: std.file({
 *         input: "saml-metadata.xml",
 *     }).then(invoke => invoke.result),
 * });
 * const main = new aws.cognito.IdentityPool("main", {
 *     identityPoolName: "identity pool",
 *     allowUnauthenticatedIdentities: false,
 *     allowClassicFlow: false,
 *     cognitoIdentityProviders: [
 *         {
 *             clientId: "6lhlkkfbfb4q5kpp90urffae",
 *             providerName: "cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ",
 *             serverSideTokenCheck: false,
 *         },
 *         {
 *             clientId: "7kodkvfqfb4qfkp39eurffae",
 *             providerName: "cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu",
 *             serverSideTokenCheck: false,
 *         },
 *     ],
 *     supportedLoginProviders: {
 *         "graph.facebook.com": "7346241598935552",
 *         "accounts.google.com": "123456789012.apps.googleusercontent.com",
 *     },
 *     samlProviderArns: [_default&#46;arn],
 *     openidConnectProviderArns: ["arn:aws:iam::123456789012:oidc-provider/id&#46;example&#46;com"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * default = aws.iam.SamlProvider("default",
 *     name="my-saml-provider",
 *     saml_metadata_document=std.file(input="saml-metadata.xml").result)
 * main = aws.cognito.IdentityPool("main",
 *     identity_pool_name="identity pool",
 *     allow_unauthenticated_identities=False,
 *     allow_classic_flow=False,
 *     cognito_identity_providers=[
 *         {
 *             "client_id": "6lhlkkfbfb4q5kpp90urffae",
 *             "provider_name": "cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ",
 *             "server_side_token_check": False,
 *         },
 *         {
 *             "client_id": "7kodkvfqfb4qfkp39eurffae",
 *             "provider_name": "cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu",
 *             "server_side_token_check": False,
 *         },
 *     ],
 *     supported_login_providers={
 *         "graph.facebook.com": "7346241598935552",
 *         "accounts.google.com": "123456789012.apps.googleusercontent.com",
 *     },
 *     saml_provider_arns=[default&#46;arn],
 *     openid_connect_provider_arns=["arn:aws:iam::123456789012:oidc-provider/id&#46;example&#46;com"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Iam.SamlProvider("default", new()
 *     {
 *         Name = "my-saml-provider",
 *         SamlMetadataDocument = Std.File.Invoke(new()
 *         {
 *             Input = "saml-metadata.xml",
 *         }).Apply(invoke => invoke.Result),
 *     });
 *     var main = new Aws.Cognito.IdentityPool("main", new()
 *     {
 *         IdentityPoolName = "identity pool",
 *         AllowUnauthenticatedIdentities = false,
 *         AllowClassicFlow = false,
 *         CognitoIdentityProviders = new[]
 *         {
 *             new Aws.Cognito.Inputs.IdentityPoolCognitoIdentityProviderArgs
 *             {
 *                 ClientId = "6lhlkkfbfb4q5kpp90urffae",
 *                 ProviderName = "cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ",
 *                 ServerSideTokenCheck = false,
 *             },
 *             new Aws.Cognito.Inputs.IdentityPoolCognitoIdentityProviderArgs
 *             {
 *                 ClientId = "7kodkvfqfb4qfkp39eurffae",
 *                 ProviderName = "cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu",
 *                 ServerSideTokenCheck = false,
 *             },
 *         },
 *         SupportedLoginProviders =
 *         {
 *             { "graph.facebook.com", "7346241598935552" },
 *             { "accounts.google.com", "123456789012.apps.googleusercontent.com" },
 *         },
 *         SamlProviderArns = new[]
 *         {
 *             @default.Arn,
 *         },
 *         OpenidConnectProviderArns = new[]
 *         {
 *             "arn:aws:iam::123456789012:oidc-provider/id.example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "saml-metadata.xml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewSamlProvider(ctx, "default", &iam.SamlProviderArgs{
 * 			Name:                 pulumi.String("my-saml-provider"),
 * 			SamlMetadataDocument: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cognito.NewIdentityPool(ctx, "main", &cognito.IdentityPoolArgs{
 * 			IdentityPoolName:               pulumi.String("identity pool"),
 * 			AllowUnauthenticatedIdentities: pulumi.Bool(false),
 * 			AllowClassicFlow:               pulumi.Bool(false),
 * 			CognitoIdentityProviders: cognito.IdentityPoolCognitoIdentityProviderArray{
 * 				&cognito.IdentityPoolCognitoIdentityProviderArgs{
 * 					ClientId:             pulumi.String("6lhlkkfbfb4q5kpp90urffae"),
 * 					ProviderName:         pulumi.String("cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ"),
 * 					ServerSideTokenCheck: pulumi.Bool(false),
 * 				},
 * 				&cognito.IdentityPoolCognitoIdentityProviderArgs{
 * 					ClientId:             pulumi.String("7kodkvfqfb4qfkp39eurffae"),
 * 					ProviderName:         pulumi.String("cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu"),
 * 					ServerSideTokenCheck: pulumi.Bool(false),
 * 				},
 * 			},
 * 			SupportedLoginProviders: pulumi.StringMap{
 * 				"graph.facebook.com":  pulumi.String("7346241598935552"),
 * 				"accounts.google.com": pulumi.String("123456789012.apps.googleusercontent.com"),
 * 			},
 * 			SamlProviderArns: pulumi.StringArray{
 * 				_default.Arn,
 * 			},
 * 			OpenidConnectProviderArns: pulumi.StringArray{
 * 				pulumi.String("arn:aws:iam::123456789012:oidc-provider/id.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SamlProvider;
 * import com.pulumi.aws.iam.SamlProviderArgs;
 * import com.pulumi.aws.cognito.IdentityPool;
 * import com.pulumi.aws.cognito.IdentityPoolArgs;
 * import com.pulumi.aws.cognito.inputs.IdentityPoolCognitoIdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SamlProvider("default", SamlProviderArgs.builder()
 *             .name("my-saml-provider")
 *             .samlMetadataDocument(StdFunctions.file(FileArgs.builder()
 *                 .input("saml-metadata.xml")
 *                 .build()).result())
 *             .build());
 *         var main = new IdentityPool("main", IdentityPoolArgs.builder()
 *             .identityPoolName("identity pool")
 *             .allowUnauthenticatedIdentities(false)
 *             .allowClassicFlow(false)
 *             .cognitoIdentityProviders(
 *                 IdentityPoolCognitoIdentityProviderArgs.builder()
 *                     .clientId("6lhlkkfbfb4q5kpp90urffae")
 *                     .providerName("cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ")
 *                     .serverSideTokenCheck(false)
 *                     .build(),
 *                 IdentityPoolCognitoIdentityProviderArgs.builder()
 *                     .clientId("7kodkvfqfb4qfkp39eurffae")
 *                     .providerName("cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu")
 *                     .serverSideTokenCheck(false)
 *                     .build())
 *             .supportedLoginProviders(Map.ofEntries(
 *                 Map.entry("graph.facebook.com", "7346241598935552"),
 *                 Map.entry("accounts.google.com", "123456789012.apps.googleusercontent.com")
 *             ))
 *             .samlProviderArns(default_.arn())
 *             .openidConnectProviderArns("arn:aws:iam::123456789012:oidc-provider/id.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:iam:SamlProvider
 *     properties:
 *       name: my-saml-provider
 *       samlMetadataDocument:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: saml-metadata.xml
 *           Return: result
 *   main:
 *     type: aws:cognito:IdentityPool
 *     properties:
 *       identityPoolName: identity pool
 *       allowUnauthenticatedIdentities: false
 *       allowClassicFlow: false
 *       cognitoIdentityProviders:
 *         - clientId: 6lhlkkfbfb4q5kpp90urffae
 *           providerName: cognito-idp.us-east-1.amazonaws.com/us-east-1_Tv0493apJ
 *           serverSideTokenCheck: false
 *         - clientId: 7kodkvfqfb4qfkp39eurffae
 *           providerName: cognito-idp.us-east-1.amazonaws.com/eu-west-1_Zr231apJu
 *           serverSideTokenCheck: false
 *       supportedLoginProviders:
 *         graph.facebook.com: '7346241598935552'
 *         accounts.google.com: 123456789012.apps.googleusercontent.com
 *       samlProviderArns:
 *         - ${default.arn}
 *       openidConnectProviderArns:
 *         - arn:aws:iam::123456789012:oidc-provider/id.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool using its ID. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityPool:IdentityPool mypool us-west-2:1a234567-8901-234b-5cde-f6789g01h2i3
 * ```
 */
public class IdentityPool internal constructor(
    override val javaResource: com.pulumi.aws.cognito.IdentityPool,
) : KotlinCustomResource(javaResource, IdentityPoolMapper) {
    /**
     * Enables or disables the classic / basic authentication flow. Default is `false`.
     */
    public val allowClassicFlow: Output<Boolean>?
        get() = javaResource.allowClassicFlow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the identity pool supports unauthenticated logins or not.
     */
    public val allowUnauthenticatedIdentities: Output<Boolean>?
        get() = javaResource.allowUnauthenticatedIdentities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the identity pool.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * An array of Amazon Cognito Identity user pools and their client IDs.
     */
    public val cognitoIdentityProviders: Output<List<IdentityPoolCognitoIdentityProvider>>?
        get() = javaResource.cognitoIdentityProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your
     * backend and the Cognito service to communicate about the developer provider.
     */
    public val developerProviderName: Output<String>?
        get() = javaResource.developerProviderName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Cognito Identity Pool name.
     */
    public val identityPoolName: Output<String>
        get() = javaResource.identityPoolName().applyValue({ args0 -> args0 })

    /**
     * Set of OpendID Connect provider ARNs.
     */
    public val openidConnectProviderArns: Output<List<String>>?
        get() = javaResource.openidConnectProviderArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * An array of Amazon Resource Names (ARNs) of the SAML provider for your identity.
     */
    public val samlProviderArns: Output<List<String>>?
        get() = javaResource.samlProviderArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Key-Value pairs mapping provider names to provider app IDs.
     */
    public val supportedLoginProviders: Output<Map<String, String>>?
        get() = javaResource.supportedLoginProviders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Identity Pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IdentityPoolMapper : ResourceMapper<IdentityPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.IdentityPool::class == javaResource::class

    override fun map(javaResource: Resource): IdentityPool = IdentityPool(
        javaResource as
            com.pulumi.aws.cognito.IdentityPool,
    )
}

/**
 * @see [IdentityPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityPool].
 */
public suspend fun identityPool(
    name: String,
    block: suspend IdentityPoolResourceBuilder.() -> Unit,
): IdentityPool {
    val builder = IdentityPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityPool(name: String): IdentityPool {
    val builder = IdentityPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
