@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IdentityPoolProviderPrincipalTag].
 */
@PulumiTagMarker
public class IdentityPoolProviderPrincipalTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityPoolProviderPrincipalTagArgs = IdentityPoolProviderPrincipalTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityPoolProviderPrincipalTagArgsBuilder.() -> Unit) {
        val builder = IdentityPoolProviderPrincipalTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IdentityPoolProviderPrincipalTag {
        val builtJavaResource =
            com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTag(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IdentityPoolProviderPrincipalTag(builtJavaResource)
    }
}

/**
 * Provides an AWS Cognito Identity Principal Mapping.
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID and provider name. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag example us-west-2_abc123:CorpAD
 * ```
 */
public class IdentityPoolProviderPrincipalTag internal constructor(
    override val javaResource: com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTag,
) : KotlinCustomResource(javaResource, IdentityPoolProviderPrincipalTagMapper) {
    /**
     * An identity pool ID.
     */
    public val identityPoolId: Output<String>
        get() = javaResource.identityPoolId().applyValue({ args0 -> args0 })

    /**
     * The name of the identity provider.
     */
    public val identityProviderName: Output<String>
        get() = javaResource.identityProviderName().applyValue({ args0 -> args0 })

    /**
     * String to string map of variables.
     */
    public val principalTags: Output<Map<String, String>>?
        get() = javaResource.principalTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * use default (username and clientID) attribute mappings.
     */
    public val useDefaults: Output<Boolean>?
        get() = javaResource.useDefaults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object IdentityPoolProviderPrincipalTagMapper :
    ResourceMapper<IdentityPoolProviderPrincipalTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTag::class == javaResource::class

    override fun map(javaResource: Resource): IdentityPoolProviderPrincipalTag =
        IdentityPoolProviderPrincipalTag(
            javaResource as
                com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTag,
        )
}

/**
 * @see [IdentityPoolProviderPrincipalTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityPoolProviderPrincipalTag].
 */
public suspend fun identityPoolProviderPrincipalTag(
    name: String,
    block: suspend IdentityPoolProviderPrincipalTagResourceBuilder.() -> Unit,
): IdentityPoolProviderPrincipalTag {
    val builder = IdentityPoolProviderPrincipalTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityPoolProviderPrincipalTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityPoolProviderPrincipalTag(name: String): IdentityPoolProviderPrincipalTag {
    val builder = IdentityPoolProviderPrincipalTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
