@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Cognito Identity Principal Mapping.
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID and provider name. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityPoolProviderPrincipalTag:IdentityPoolProviderPrincipalTag example us-west-2_abc123:CorpAD
 * ```
 * @property identityPoolId An identity pool ID.
 * @property identityProviderName The name of the identity provider.
 * @property principalTags String to string map of variables.
 * @property useDefaults use default (username and clientID) attribute mappings.
 */
public data class IdentityPoolProviderPrincipalTagArgs(
    public val identityPoolId: Output<String>? = null,
    public val identityProviderName: Output<String>? = null,
    public val principalTags: Output<Map<String, String>>? = null,
    public val useDefaults: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTagArgs> {
    override fun toJava(): com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTagArgs =
        com.pulumi.aws.cognito.IdentityPoolProviderPrincipalTagArgs.builder()
            .identityPoolId(identityPoolId?.applyValue({ args0 -> args0 }))
            .identityProviderName(identityProviderName?.applyValue({ args0 -> args0 }))
            .principalTags(
                principalTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .useDefaults(useDefaults?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityPoolProviderPrincipalTagArgs].
 */
@PulumiTagMarker
public class IdentityPoolProviderPrincipalTagArgsBuilder internal constructor() {
    private var identityPoolId: Output<String>? = null

    private var identityProviderName: Output<String>? = null

    private var principalTags: Output<Map<String, String>>? = null

    private var useDefaults: Output<Boolean>? = null

    /**
     * @param value An identity pool ID.
     */
    @JvmName("waeiqncxwrfxwfns")
    public suspend fun identityPoolId(`value`: Output<String>) {
        this.identityPoolId = value
    }

    /**
     * @param value The name of the identity provider.
     */
    @JvmName("hocrdxckvyfwpwpu")
    public suspend fun identityProviderName(`value`: Output<String>) {
        this.identityProviderName = value
    }

    /**
     * @param value String to string map of variables.
     */
    @JvmName("kjokafdqsdvbxego")
    public suspend fun principalTags(`value`: Output<Map<String, String>>) {
        this.principalTags = value
    }

    /**
     * @param value use default (username and clientID) attribute mappings.
     */
    @JvmName("mjopwswtylpagidr")
    public suspend fun useDefaults(`value`: Output<Boolean>) {
        this.useDefaults = value
    }

    /**
     * @param value An identity pool ID.
     */
    @JvmName("pxfaeujbkrixhcvu")
    public suspend fun identityPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityPoolId = mapped
    }

    /**
     * @param value The name of the identity provider.
     */
    @JvmName("dyurcsyqahclmlqy")
    public suspend fun identityProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderName = mapped
    }

    /**
     * @param value String to string map of variables.
     */
    @JvmName("joytvvdbfsakkvwv")
    public suspend fun principalTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalTags = mapped
    }

    /**
     * @param values String to string map of variables.
     */
    @JvmName("gtngwamtpnbhlkmv")
    public fun principalTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalTags = mapped
    }

    /**
     * @param value use default (username and clientID) attribute mappings.
     */
    @JvmName("onpugqfijpttwgnh")
    public suspend fun useDefaults(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDefaults = mapped
    }

    internal fun build(): IdentityPoolProviderPrincipalTagArgs = IdentityPoolProviderPrincipalTagArgs(
        identityPoolId = identityPoolId,
        identityProviderName = identityProviderName,
        principalTags = principalTags,
        useDefaults = useDefaults,
    )
}
