@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.kotlin.outputs.IdentityPoolRoleAttachmentRoleMapping
import com.pulumi.aws.cognito.kotlin.outputs.IdentityPoolRoleAttachmentRoleMapping.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IdentityPoolRoleAttachment].
 */
@PulumiTagMarker
public class IdentityPoolRoleAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityPoolRoleAttachmentArgs = IdentityPoolRoleAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityPoolRoleAttachmentArgsBuilder.() -> Unit) {
        val builder = IdentityPoolRoleAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IdentityPoolRoleAttachment {
        val builtJavaResource =
            com.pulumi.aws.cognito.IdentityPoolRoleAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IdentityPoolRoleAttachment(builtJavaResource)
    }
}

/**
 * Provides an AWS Cognito Identity Pool Roles Attachment.
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityPoolRoleAttachment:IdentityPoolRoleAttachment example us-west-2:b64805ad-cb56-40ba-9ffc-f5d8207e6d42
 * ```
 */
public class IdentityPoolRoleAttachment internal constructor(
    override val javaResource: com.pulumi.aws.cognito.IdentityPoolRoleAttachment,
) : KotlinCustomResource(javaResource, IdentityPoolRoleAttachmentMapper) {
    /**
     * An identity pool ID in the format `REGION_GUID`.
     */
    public val identityPoolId: Output<String>
        get() = javaResource.identityPoolId().applyValue({ args0 -> args0 })

    /**
     * A List of Role Mapping.
     */
    public val roleMappings: Output<List<IdentityPoolRoleAttachmentRoleMapping>>?
        get() = javaResource.roleMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    public val roles: Output<Map<String, String>>
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IdentityPoolRoleAttachmentMapper : ResourceMapper<IdentityPoolRoleAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.cognito.IdentityPoolRoleAttachment::class == javaResource::class

    override fun map(javaResource: Resource): IdentityPoolRoleAttachment =
        IdentityPoolRoleAttachment(javaResource as com.pulumi.aws.cognito.IdentityPoolRoleAttachment)
}

/**
 * @see [IdentityPoolRoleAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityPoolRoleAttachment].
 */
public suspend fun identityPoolRoleAttachment(
    name: String,
    block: suspend IdentityPoolRoleAttachmentResourceBuilder.() -> Unit,
): IdentityPoolRoleAttachment {
    val builder = IdentityPoolRoleAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityPoolRoleAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityPoolRoleAttachment(name: String): IdentityPoolRoleAttachment {
    val builder = IdentityPoolRoleAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
