@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin

import com.pulumi.aws.cognito.IdentityPoolRoleAttachmentArgs.builder
import com.pulumi.aws.cognito.kotlin.inputs.IdentityPoolRoleAttachmentRoleMappingArgs
import com.pulumi.aws.cognito.kotlin.inputs.IdentityPoolRoleAttachmentRoleMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Cognito Identity Pool Roles Attachment.
 * ## Import
 * Using `pulumi import`, import Cognito Identity Pool Roles Attachment using the Identity Pool ID. For example:
 * ```sh
 * $ pulumi import aws:cognito/identityPoolRoleAttachment:IdentityPoolRoleAttachment example us-west-2:b64805ad-cb56-40ba-9ffc-f5d8207e6d42
 * ```
 * @property identityPoolId An identity pool ID in the format `REGION_GUID`.
 * @property roleMappings A List of Role Mapping.
 * @property roles The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
 */
public data class IdentityPoolRoleAttachmentArgs(
    public val identityPoolId: Output<String>? = null,
    public val roleMappings: Output<List<IdentityPoolRoleAttachmentRoleMappingArgs>>? = null,
    public val roles: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.IdentityPoolRoleAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.cognito.IdentityPoolRoleAttachmentArgs =
        com.pulumi.aws.cognito.IdentityPoolRoleAttachmentArgs.builder()
            .identityPoolId(identityPoolId?.applyValue({ args0 -> args0 }))
            .roleMappings(
                roleMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .roles(
                roles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IdentityPoolRoleAttachmentArgs].
 */
@PulumiTagMarker
public class IdentityPoolRoleAttachmentArgsBuilder internal constructor() {
    private var identityPoolId: Output<String>? = null

    private var roleMappings: Output<List<IdentityPoolRoleAttachmentRoleMappingArgs>>? = null

    private var roles: Output<Map<String, String>>? = null

    /**
     * @param value An identity pool ID in the format `REGION_GUID`.
     */
    @JvmName("bbinjlnirsfkrmoy")
    public suspend fun identityPoolId(`value`: Output<String>) {
        this.identityPoolId = value
    }

    /**
     * @param value A List of Role Mapping.
     */
    @JvmName("pdytjrdwklshwcsb")
    public suspend fun roleMappings(`value`: Output<List<IdentityPoolRoleAttachmentRoleMappingArgs>>) {
        this.roleMappings = value
    }

    @JvmName("swrsoicisjmkuufp")
    public suspend fun roleMappings(vararg values: Output<IdentityPoolRoleAttachmentRoleMappingArgs>) {
        this.roleMappings = Output.all(values.asList())
    }

    /**
     * @param values A List of Role Mapping.
     */
    @JvmName("evbthvypxywsikkt")
    public suspend fun roleMappings(values: List<Output<IdentityPoolRoleAttachmentRoleMappingArgs>>) {
        this.roleMappings = Output.all(values)
    }

    /**
     * @param value The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    @JvmName("qsoxperyxvhadtbf")
    public suspend fun roles(`value`: Output<Map<String, String>>) {
        this.roles = value
    }

    /**
     * @param value An identity pool ID in the format `REGION_GUID`.
     */
    @JvmName("xfusujldryphynyt")
    public suspend fun identityPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityPoolId = mapped
    }

    /**
     * @param value A List of Role Mapping.
     */
    @JvmName("lthrpkjvcbkxdpsw")
    public suspend fun roleMappings(`value`: List<IdentityPoolRoleAttachmentRoleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleMappings = mapped
    }

    /**
     * @param argument A List of Role Mapping.
     */
    @JvmName("kqkgwvlgjrseuopr")
    public suspend fun roleMappings(argument: List<suspend IdentityPoolRoleAttachmentRoleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IdentityPoolRoleAttachmentRoleMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.roleMappings = mapped
    }

    /**
     * @param argument A List of Role Mapping.
     */
    @JvmName("cihqpxnlqwfpkctc")
    public suspend fun roleMappings(vararg argument: suspend IdentityPoolRoleAttachmentRoleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IdentityPoolRoleAttachmentRoleMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.roleMappings = mapped
    }

    /**
     * @param argument A List of Role Mapping.
     */
    @JvmName("eqmgekkjgdggsyaj")
    public suspend fun roleMappings(argument: suspend IdentityPoolRoleAttachmentRoleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IdentityPoolRoleAttachmentRoleMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.roleMappings = mapped
    }

    /**
     * @param values A List of Role Mapping.
     */
    @JvmName("plaryyyypqtvhjic")
    public suspend fun roleMappings(vararg values: IdentityPoolRoleAttachmentRoleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleMappings = mapped
    }

    /**
     * @param value The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    @JvmName("olpxrcrpjtqhkurk")
    public suspend fun roles(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values The map of roles associated with this pool. For a given role, the key will be either "authenticated" or "unauthenticated" and the value will be the Role ARN.
     */
    @JvmName("vyauilpmcgkuksjf")
    public fun roles(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): IdentityPoolRoleAttachmentArgs = IdentityPoolRoleAttachmentArgs(
        identityPoolId = identityPoolId,
        roleMappings = roleMappings,
        roles = roles,
    )
}
